/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.ChestedHorseAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Llama;

public class LlamaAdapter<T extends Llama>
extends ChestedHorseAdapter<T> {
    public LlamaAdapter(@Nonnull Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Color: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("color").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setColor(Llama.Color.valueOf((String)json.get("color").getAsString()));
        entity.setStrength(json.get("spitStrength").getAsInt());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("color", entity.getColor().name());
        json.addProperty("spitStrength", (Number)entity.getStrength());
        return json;
    }
}

