/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Vex;

public class VexAdapter
implements MobAdapter<Vex> {
    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(ChatColor.GRAY + "Charging: " + ChatColor.WHITE + json.get("charging").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Vex entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        entity.setCharging(json.get("charging").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Vex entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("charging", Boolean.valueOf(entity.isCharging()));
        return json;
    }

    @Override
    @Nonnull
    public Class<Vex> getEntityClass() {
        return Vex.class;
    }
}

