/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractTameableAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Parrot;

public class ParrotAdapter
extends AbstractTameableAdapter<Parrot> {
    public ParrotAdapter() {
        super(Parrot.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("variant").getAsString()));
        if (!json.get("ownerUUID").isJsonNull()) {
            lore.add(ChatColor.GRAY + "Sitting: " + ChatColor.WHITE + json.get("sitting").getAsBoolean());
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Parrot entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVariant(Parrot.Variant.valueOf((String)json.get("variant").getAsString()));
        entity.setSitting(json.get("sitting").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Parrot entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("variant", entity.getVariant().name());
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        return json;
    }
}

