/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.MushroomCow;

public class MooshroomAdapter
extends AnimalsAdapter<MushroomCow> {
    public MooshroomAdapter() {
        super(MushroomCow.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("variant").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(MushroomCow entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVariant(MushroomCow.Variant.valueOf((String)json.get("variant").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull MushroomCow entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("variant", entity.getVariant().name());
        return json;
    }
}

