/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.listeners;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.items.MobEgg;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PelletListener
implements Listener {
    private final MobCapturer plugin;

    public PelletListener(@Nonnull MobCapturer plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onProjectileHit(@Nonnull EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Snowball) {
            Snowball pellet = (Snowball)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                Optional<ItemStack> optional;
                Player player;
                LivingEntity entity2 = (LivingEntity)entity;
                if (pellet.hasMetadata("mob_capturing_cannon") && (entity = pellet.getShooter()) instanceof Player && this.canCapture(player = (Player)entity, entity2) && (optional = this.capture(entity2)).isPresent()) {
                    pellet.removeMetadata("mob_capturing_cannon", (Plugin)this.plugin);
                    entity2.remove();
                    entity2.getWorld().dropItemNaturally(entity2.getEyeLocation(), optional.get());
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean canCapture(Player p, LivingEntity entity) {
        if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, entity.getLocation(), Interaction.ATTACK_ENTITY)) {
            return false;
        }
        List ignoredMobNames = MobCapturer.getRegistry().getConfig().getStringList("options.ignored-mobs");
        if (ignoredMobNames.contains(entity.getCustomName())) {
            return false;
        }
        if (MobCapturer.getRegistry().getConfig().getBoolean("options.capture-named-mobs")) {
            return entity.getCustomName() != null;
        }
        return true;
    }

    @Nonnull
    protected Optional<ItemStack> capture(@Nonnull LivingEntity entity) {
        MobEgg<?> egg = MobCapturer.getRegistry().getAdapters().get(entity.getType());
        if (egg != null) {
            ItemStack item = egg.getEggItem(entity);
            return Optional.of(item);
        }
        return Optional.empty();
    }
}

