/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Goat;

public class GoatAdapter
extends AnimalsAdapter<Goat> {
    public GoatAdapter() {
        super(Goat.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Screaming: " + ChatColor.WHITE + json.get("screaming").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Goat entity, JsonObject json) {
        super.apply(entity, json);
        entity.setScreaming(json.get("screaming").getAsBoolean());
        if (this.hasHornMethods() && json.has("hasLeftHorn")) {
            entity.setLeftHorn(json.get("hasLeftHorn").getAsBoolean());
            entity.setRightHorn(json.get("hasRightHorn").getAsBoolean());
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Goat entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("screaming", Boolean.valueOf(entity.isScreaming()));
        if (this.hasHornMethods()) {
            json.addProperty("hasLeftHorn", Boolean.valueOf(entity.hasLeftHorn()));
            json.addProperty("hasRightHorn", Boolean.valueOf(entity.hasRightHorn()));
        }
        return json;
    }

    private boolean hasHornMethods() {
        return Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_19);
    }
}

