/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Frog;

public class FrogAdapter
extends AnimalsAdapter<Frog> {
    public FrogAdapter() {
        super(Frog.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("variant").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Frog entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVariant(Frog.Variant.valueOf((String)json.get("variant").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Frog entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("variant", entity.getVariant().name());
        return json;
    }
}

