/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.entity.Bee;

public class BeeAdapter
extends AnimalsAdapter<Bee> {
    public BeeAdapter() {
        super(Bee.class);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Bee entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAnger(json.get("anger").getAsInt());
        entity.setCannotEnterHiveTicks(json.get("cannotEnterHiveTicks").getAsInt());
        entity.setHasNectar(json.get("nectar").getAsBoolean());
        entity.setHasStung(json.get("stung").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Bee entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("anger", (Number)entity.getAnger());
        json.addProperty("cannotEnterHiveTicks", (Number)entity.getCannotEnterHiveTicks());
        json.addProperty("nectar", Boolean.valueOf(entity.hasNectar()));
        json.addProperty("stung", Boolean.valueOf(entity.hasStung()));
        return json;
    }
}

