/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Pig;

public class PigAdapter
extends AnimalsAdapter<Pig> {
    public PigAdapter() {
        super(Pig.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        if (json.get("saddle").getAsBoolean()) {
            lore.add(ChatColor.GRAY + "+ Saddle");
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Pig entity, JsonObject json) {
        super.apply(entity, json);
        entity.setSaddle(json.get("saddle").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Pig entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("saddle", Boolean.valueOf(entity.hasSaddle()));
        return json;
    }
}

