/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PelletListener
implements Listener {
    private final MobCapturer plugin;

    public PelletListener(@Nonnull MobCapturer plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onProjectileHit(@Nonnull EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Snowball) {
            Snowball pellet = (Snowball)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                Optional<ItemStack> optional;
                Player player;
                ProjectileSource shooter;
                LivingEntity entity2 = (LivingEntity)entity;
                if (e.getDamager().hasMetadata("mob_capturing_cannon") && (shooter = pellet.getShooter()) instanceof Player && this.canCapture(player = (Player)shooter, e.getEntity().getLocation()) && (optional = this.plugin.capture(entity2)).isPresent()) {
                    e.getDamager().removeMetadata("mob_capturing_cannon", (Plugin)this.plugin);
                    e.getEntity().remove();
                    e.getEntity().getWorld().dropItemNaturally(entity2.getEyeLocation(), optional.get());
                }
            }
        }
    }

    protected boolean canCapture(Player p, Location l) {
        return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, l, Interaction.ATTACK_ENTITY);
    }
}

