/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.items;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.InventoryAdapter;
import io.github.thebusybiscuit.mobcapturer.MobAdapter;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MobEgg<T extends LivingEntity>
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private final NamespacedKey dataKey;
    private final NamespacedKey inventoryKey;
    private final MobAdapter<T> adapter;

    @ParametersAreNonnullByDefault
    public MobEgg(ItemGroup itemGroup, SlimefunItemStack item, NamespacedKey dataKey, NamespacedKey inventoryKey, MobAdapter<T> adapter, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.dataKey = dataKey;
        this.inventoryKey = inventoryKey;
        this.adapter = adapter;
    }

    public ItemStack getEggItem(@Nonnull T entity) {
        JsonObject json = this.adapter.saveData(entity);
        ItemStack item = this.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        meta.setLore(this.adapter.getLore(json));
        meta.getPersistentDataContainer().set(this.dataKey, this.adapter, (Object)json);
        if (this.adapter instanceof InventoryAdapter) {
            YamlConfiguration yaml = new YamlConfiguration();
            for (Map.Entry<String, ItemStack> entry : ((InventoryAdapter)((Object)this.adapter)).saveInventory(entity).entrySet()) {
                yaml.set(entry.getKey(), (Object)entry.getValue());
            }
            meta.getPersistentDataContainer().set(this.inventoryKey, PersistentDataType.STRING, (Object)yaml.saveToString());
        }
        item.setItemMeta(meta);
        return item;
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Optional block = e.getClickedBlock();
            if (block.isPresent()) {
                Block b = (Block)block.get();
                if (this.canPlaceMob(e.getPlayer(), b.getRelative(e.getClickedFace()).getLocation())) {
                    LivingEntity entity = (LivingEntity)b.getWorld().spawn(b.getRelative(e.getClickedFace()).getLocation(), this.adapter.getEntityClass());
                    PersistentDataContainer container = e.getItem().getItemMeta().getPersistentDataContainer();
                    JsonObject json = (JsonObject)container.get(this.dataKey, this.adapter);
                    ItemUtils.consumeItem((ItemStack)e.getItem(), (boolean)false);
                    if (json != null) {
                        this.adapter.apply(entity, json);
                        if (this.adapter instanceof InventoryAdapter) {
                            HashMap<String, ItemStack> inventory = new HashMap<String, ItemStack>();
                            try (StringReader reader = new StringReader((String)container.get(this.inventoryKey, PersistentDataType.STRING));){
                                YamlConfiguration yaml = YamlConfiguration.loadConfiguration((Reader)reader);
                                for (String key : yaml.getKeys(true)) {
                                    Object obj = yaml.get(key);
                                    if (!(obj instanceof ItemStack)) continue;
                                    inventory.put(key, (ItemStack)obj);
                                }
                            }
                            catch (IOException x) {
                                x.printStackTrace();
                            }
                            ((InventoryAdapter)((Object)this.adapter)).applyInventory(entity, inventory);
                        }
                    }
                }
            }
        };
    }

    @ParametersAreNonnullByDefault
    protected boolean canPlaceMob(Player p, Location l) {
        return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, l, Interaction.PLACE_BLOCK);
    }
}

