/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.MobAdapter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.PufferFish;

public class PufferFishAdapter
implements MobAdapter<PufferFish> {
    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(ChatColor.GRAY + "Puffiness: " + ChatColor.WHITE + json.get("puffState").getAsInt());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(PufferFish entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        entity.setPuffState(json.get("puffState").getAsInt());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull PufferFish entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("puffState", (Number)entity.getPuffState());
        return json;
    }

    @Override
    @Nonnull
    public Class<PufferFish> getEntityClass() {
        return PufferFish.class;
    }
}

