/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AbstractHumanoidAdapter;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.PiglinBrute;

public class PiglinBruteAdapter
extends AbstractHumanoidAdapter<PiglinBrute> {
    public PiglinBruteAdapter() {
        super(PiglinBrute.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Baby: " + ChatColor.WHITE + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    public void apply(PiglinBrute entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAge(json.get("age").getAsInt());
        entity.setConversionTime(json.get("conversionTime").getAsInt());
        entity.setImmuneToZombification(json.get("immuneToZombification").getAsBoolean());
    }

    @Override
    public JsonObject saveData(PiglinBrute entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("age", (Number)entity.getAge());
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        json.addProperty("conversionTime", (Number)entity.getConversionTime());
        json.addProperty("immuneToZombification", Boolean.valueOf(entity.isImmuneToZombification()));
        return json;
    }
}

