/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Hoglin;

public class HoglinAdapter
extends AnimalsAdapter<Hoglin> {
    public HoglinAdapter() {
        super(Hoglin.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Baby: " + ChatColor.WHITE + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    public void apply(Hoglin entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAge(json.get("age").getAsInt());
        entity.setIsAbleToBeHunted(json.get("ableToBeHunted").getAsBoolean());
        entity.setConversionTime(json.get("conversionTime").getAsInt());
        entity.setImmuneToZombification(json.get("immuneToZombification").getAsBoolean());
    }

    @Override
    public JsonObject saveData(Hoglin entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("age", (Number)entity.getAge());
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        json.addProperty("ableToBeHunted", Boolean.valueOf(entity.isAbleToBeHunted()));
        json.addProperty("conversionTime", (Number)entity.getConversionTime());
        json.addProperty("immuneToZombification", Boolean.valueOf(entity.isImmuneToZombification()));
        return json;
    }
}

