/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.items;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.items.MobPellet;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobCannon
extends SimpleSlimefunItem<ItemUseHandler> {
    private final MobCapturer plugin;
    private final MobPellet pellet;

    public MobCannon(MobCapturer plugin, ItemGroup itemGroup, SlimefunItemStack item, MobPellet pellet, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.plugin = plugin;
        this.pellet = pellet;
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            if (this.consumeAmmo(e.getPlayer(), this.pellet)) {
                Snowball projectile = (Snowball)e.getPlayer().launchProjectile(Snowball.class);
                projectile.setMetadata("mob_capturing_cannon", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)e.getPlayer().getUniqueId()));
            }
        };
    }

    private boolean consumeAmmo(Player p, MobPellet pellet) {
        if (p.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        for (ItemStack item : p.getInventory()) {
            if (!pellet.isItem(item)) continue;
            ItemUtils.consumeItem((ItemStack)item, (boolean)false);
            return true;
        }
        return false;
    }
}

