/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Panda;

public class PandaAdapter
extends AnimalsAdapter<Panda> {
    public PandaAdapter() {
        super(Panda.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Main Gene: " + ChatColor.WHITE + StringUtils.format((String)json.get("mainGene").getAsString()));
        lore.add(ChatColor.GRAY + "Hidden Gene: " + ChatColor.WHITE + StringUtils.format((String)json.get("hiddenGene").getAsString()));
        return lore;
    }

    @Override
    public void apply(Panda entity, JsonObject json) {
        super.apply(entity, json);
        entity.setMainGene(Panda.Gene.valueOf((String)json.get("mainGene").getAsString()));
        entity.setHiddenGene(Panda.Gene.valueOf((String)json.get("hiddenGene").getAsString()));
    }

    @Override
    public JsonObject saveData(Panda entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("mainGene", entity.getMainGene().name());
        json.addProperty("hiddenGene", entity.getHiddenGene().name());
        return json;
    }
}

