/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.ChestedHorseAdapter;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Llama;

public class LlamaAdapter<T extends Llama>
extends ChestedHorseAdapter<T> {
    public LlamaAdapter(Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Color: " + ChatColor.WHITE + StringUtils.format((String)json.get("color").getAsString()));
        return lore;
    }

    @Override
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setColor(Llama.Color.valueOf((String)json.get("color").getAsString()));
        entity.setStrength(json.get("spitStrength").getAsInt());
    }

    @Override
    public JsonObject saveData(T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("color", entity.getColor().name());
        json.addProperty("spitStrength", (Number)entity.getStrength());
        return json;
    }
}

