/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AbstractTameableAdapter;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Parrot;

public class ParrotAdapter
extends AbstractTameableAdapter<Parrot> {
    public ParrotAdapter() {
        super(Parrot.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.WHITE + StringUtils.format((String)json.get("variant").getAsString()));
        if (!json.get("ownerUUID").isJsonNull()) {
            lore.add(ChatColor.GRAY + "Sitting: " + ChatColor.WHITE + json.get("sitting").getAsBoolean());
        }
        return lore;
    }

    @Override
    public void apply(Parrot entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVariant(Parrot.Variant.valueOf((String)json.get("variant").getAsString()));
        entity.setSitting(json.get("sitting").getAsBoolean());
    }

    @Override
    public JsonObject saveData(Parrot entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("variant", entity.getVariant().name());
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        return json;
    }
}

