/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.utils;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class SlimefunUtils {
    private static final Map<ItemGroup, List<Integer>> INDEX_OFFSETS = new HashMap<ItemGroup, List<Integer>>();

    private static SlimefunItemStack errorItemStack(String id) {
        return new SlimefunItemStack("MM_ERROR_" + id.toUpperCase(), Material.BARRIER, "&cIncorrect Id: " + id, new String[0]);
    }

    public static void loadWithPosition(SlimefunItem slimefunItem, int position) {
        ItemGroup itemGroup = slimefunItem.getItemGroup();
        List items = itemGroup.getItems();
        RecipeType recipeType = slimefunItem.getRecipeType();
        ItemStack[] recipe = slimefunItem.getRecipe();
        ItemStack output = slimefunItem.getRecipeOutput();
        List offsets = INDEX_OFFSETS.getOrDefault(itemGroup, new ArrayList());
        int difference = 0;
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            if (offset >= position) continue;
            ++difference;
        }
        offsets.add(position);
        INDEX_OFFSETS.put(itemGroup, offsets);
        if ((position += difference) < 0 || position > items.size()) {
            slimefunItem.warn("Position is invalid, appending to the item group normally.");
            position = items.size() - 1;
        }
        if (!slimefunItem.isHidden()) {
            items.add(position, slimefunItem);
        }
        recipeType.register(recipe, output);
    }

    public static ItemGroup getItemGroup(String id) {
        String[] pair = id.split(":");
        String itemGroupId = pair[0];
        String itemId = pair[1];
        for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
            if (!itemGroup.getKey().getNamespace().equals(itemGroupId) || !itemGroup.getKey().getKey().equals(itemId)) continue;
            return itemGroup;
        }
        return null;
    }

    public static SlimefunItemStack getSlimefunItem(String id) {
        SlimefunItem slimefunItem = (SlimefunItem)Slimefun.getRegistry().getSlimefunItemIds().get(id);
        return slimefunItem != null ? (SlimefunItemStack)slimefunItem.getItem().clone() : SlimefunUtils.errorItemStack(id);
    }

    public static SlimefunItemStack getSlimefunItem(String id, int amount) {
        return new SlimefunItemStack(SlimefunUtils.getSlimefunItem(id), amount);
    }
}

