/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.dough.items.nms;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.metacoin.metalib.dough.common.DoughLogger;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapter17;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapter18;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapter18v2;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapter19;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapterBefore17;
import org.metamechanists.metacoin.metalib.dough.items.nms.ItemNameAdapterMockBukkit;
import org.metamechanists.metacoin.metalib.dough.versions.MinecraftVersion;

public interface ItemNameAdapter {
    @ParametersAreNonnullByDefault
    @Nonnull
    public String getName(ItemStack var1) throws IllegalAccessException, InvocationTargetException;

    @Nullable
    public static ItemNameAdapter get() {
        try {
            MinecraftVersion version = MinecraftVersion.get();
            if (MinecraftVersion.isMocked()) {
                return new ItemNameAdapterMockBukkit();
            }
            if (version.isAtLeast(1, 19)) {
                return new ItemNameAdapter19();
            }
            if (version.isAtLeast(1, 18, 2)) {
                return new ItemNameAdapter18v2();
            }
            if (version.isAtLeast(1, 18)) {
                return new ItemNameAdapter18();
            }
            if (version.isAtLeast(1, 17)) {
                return new ItemNameAdapter17();
            }
            return new ItemNameAdapterBefore17();
        }
        catch (Exception x) {
            DoughLogger logger = new DoughLogger("items");
            logger.log(Level.SEVERE, "Failed to detect items nbt methods", x);
            return null;
        }
    }
}

