/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.slimefun;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.metamechanists.metacoin.metalib.utils.RandomUtils;
import org.metamechanists.metacoin.utils.Keys;

public class MetaCoinItem
extends SlimefunItem {
    private static final Map<Long, ItemStack> COINS = new LinkedHashMap<Long, ItemStack>();
    private static final List<String> FLIP_MESSAGES = List.of("The MetaCoin\u2122 flips through the air, glinting in the light. It lands... heads!", "You flip the MetaCoin\u2122. It spins, a blur of orange, yellow, and blue, and lands... tails!", "The MetaCoin\u2122 flips end over end, landing with a soft clink. It's... heads!", "You give the MetaCoin\u2122 a flick. It twirls in the air and lands... tails!", "The MetaCoin\u2122 soars through the air, spinning wildly. It lands... heads!", "You toss the MetaCoin\u2122 high. It descends slowly, finally landing... tails!", "The MetaCoin\u2122 flips, catching the light. It lands... heads!", "You flip the MetaCoin\u2122. It spins, a blur of orange, yellow, and blue, and lands... tails!", "The MetaCoin\u2122 flips end over end, landing with a soft clink. It's... heads!", "You give the MetaCoin\u2122 a flick. It twirls in the air and lands... tails!", "The MetaCoin\u2122 soars through the air, spinning wildly. It lands... heads!", "You toss the MetaCoin\u2122 high. It descends slowly, finally landing... tails!");
    private static final List<String> HINTS = List.of("The\u1d65 MetaCoin\u2122\u1d62 flies\u2097 into\u2097 the\u2090 air\u1d4d.... and\u2091 hits\u1d63 you in the head.", "The\u1d48 MetaCoin\u2122\u1d62 flies\u209b into\u209a the\u2091 air\u2099.... and\u209b hits\u2091 you\u1d63 in the head.", "The\u209a MetaCoin\u2122\u1d62 flies\u1d4d into\u2097 the\u1d62 air\u2099.... and hits you in the head.");
    private final ItemSetting<Boolean> allowTrading;
    private final ItemSetting<Double> damage;
    private final long value;

    public MetaCoinItem(ItemGroup itemGroup, SlimefunItemStack item, double damage, long value) {
        super(itemGroup, item, RecipeType.NULL, new ItemStack[0]);
        this.allowTrading = new ItemSetting((SlimefunItem)this, "allow-trading", (Object)(value >= 64L ? 1 : 0));
        this.damage = new ItemSetting((SlimefunItem)this, "damage", (Object)damage);
        this.value = value;
        this.addItemHandler(new ItemHandler[]{this.onUse()});
    }

    public void postRegister() {
        this.setHidden(true);
    }

    public ItemUseHandler onUse() {
        return event -> {
            if (event.getClickedBlock().isPresent()) {
                return;
            }
            event.cancel();
            Player player = event.getPlayer();
            if (player.getGameMode() != GameMode.CREATIVE) {
                event.getItem().subtract();
            }
            if (player.isSneaking()) {
                if (PersistentDataAPI.hasBoolean((PersistentDataHolder)player, Keys.flippingCoin)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are already flipping a coin!");
                    return;
                }
                player.launchProjectile(Snowball.class, player.getEyeLocation().getDirection().add(new Vector(0.0, 0.5, 0.0)).multiply(0.15), projectile -> {
                    projectile.setItem(this.getItem());
                    projectile.setShooter((ProjectileSource)player);
                    PersistentDataAPI.setBoolean((PersistentDataHolder)player, Keys.flippingCoin, true);
                    PersistentDataAPI.setBoolean((PersistentDataHolder)projectile, Keys.flippingCoin, true);
                });
                return;
            }
            player.launchProjectile(Snowball.class, player.getEyeLocation().getDirection().multiply(2), projectile -> {
                projectile.setItem(this.getItem());
                projectile.setShooter((ProjectileSource)player);
            });
        };
    }

    public void sendFlipResult(Player player) {
        player.sendMessage(RandomUtils.randomChoice((Boolean)this.allowTrading.getValue() != false && RandomUtils.chance(1) ? HINTS : FLIP_MESSAGES));
    }

    public static long valueOf(ItemStack itemStack) {
        return MetaCoinItem.valueOf(itemStack, true);
    }

    public static long valueOf(ItemStack itemStack, boolean includeAmount) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (slimefunItem instanceof MetaCoinItem) {
            MetaCoinItem item = (MetaCoinItem)slimefunItem;
            return item.value * (long)(includeAmount ? itemStack.getAmount() : 1);
        }
        return 0L;
    }

    public static long valueFromProductionLevel(int productionLevel) {
        if (productionLevel < 65) {
            return productionLevel;
        }
        if (productionLevel < 129) {
            return 64L * (long)(productionLevel - 63);
        }
        return 4096L * (long)(productionLevel - 127);
    }

    public static ItemStack withValue(long value) {
        Optional<Long> closestValue = MetaCoinItem.getClosestValue(value);
        if (closestValue.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        CustomItemStack result = new CustomItemStack(COINS.get(closestValue.get()), (int)Math.min(64L, value / closestValue.get()));
        ItemMeta meta = result.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(66613));
        result.setItemMeta(meta);
        return result;
    }

    public static ItemStack[] withTotalValue(long totalValue) {
        ItemStack nextStack;
        ArrayList<ItemStack> coins = new ArrayList<ItemStack>();
        while (totalValue > 0L && !(nextStack = MetaCoinItem.withValue(totalValue)).isEmpty()) {
            coins.add(nextStack);
            totalValue -= MetaCoinItem.valueOf(nextStack);
        }
        return (ItemStack[])coins.toArray(ItemStack[]::new);
    }

    public static Optional<Long> getClosestValue(long targetValue) {
        for (long value : COINS.keySet()) {
            if (value > targetValue) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static long getTotalCoinValue(Player player) {
        long totalValue = 0L;
        for (ItemStack itemStack : player.getInventory().getContents()) {
            totalValue += MetaCoinItem.valueOf(itemStack);
        }
        return totalValue;
    }

    public static List<ItemStack> getWeightedCoins(Player player) {
        ArrayList<ItemStack> coins = new ArrayList<ItemStack>();
        for (long value : COINS.keySet()) {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (MetaCoinItem.valueOf(itemStack, false) != value) continue;
                coins.add(itemStack);
            }
        }
        return coins;
    }

    public static long getRemovableCoinValue(Player player, long coins) {
        long removableCoins = 0L;
        for (ItemStack itemStack : MetaCoinItem.getWeightedCoins(player)) {
            long value = MetaCoinItem.valueOf(itemStack, false);
            if (value <= 0L || value > coins) continue;
            int countToRemove = Math.min(itemStack.getAmount(), (int)(coins / value));
            removableCoins += (long)countToRemove * value;
            if ((coins -= (long)countToRemove * value) > 0L) continue;
            break;
        }
        return removableCoins;
    }

    public static void removeCoins(Player player, long coins) {
        for (ItemStack itemStack : MetaCoinItem.getWeightedCoins(player)) {
            long value = MetaCoinItem.valueOf(itemStack, false);
            if (value <= 0L || value > coins) continue;
            int countToRemove = Math.min(itemStack.getAmount(), (int)(coins / value));
            itemStack.subtract(countToRemove);
            if ((coins -= (long)countToRemove * value) > 0L) continue;
            break;
        }
    }

    public static Map<Long, ItemStack> getCoins() {
        return COINS;
    }

    public ItemSetting<Boolean> getAllowTrading() {
        return this.allowTrading;
    }

    public ItemSetting<Double> getDamage() {
        return this.damage;
    }

    public long getValue() {
        return this.value;
    }
}

