/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.listeners;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinItem;
import org.metamechanists.metacoin.metalib.utils.RandomUtils;
import org.metamechanists.metacoin.utils.Keys;
import org.metamechanists.metacoin.utils.Utils;

public class ProjectileListener
implements Listener {
    private static final List<String> PLAYER_CAUSED_DEATH_MESSAGES = List.of("%s was annihilated by the volatile fluctuations of %s's MetaCoin\u2122 network", "%s was crushed under the weight of %s's blockchain", "%s was bankrupted by %s's MetaCoin\u2122 empire", "%s was overwhelmed by the complexity of %s's blockchain", "%s was lost in the labyrinth of %s's MetaCoin\u2122 transactions", "%s was caught in the crossfire of %s's MetaCoin\u2122 mining operation", "%s was obliterated by the sheer power of %s's MetaMiner\u2122", "%s was caught off guard by %s's sudden MetaCoin\u2122 wealth", "%s was left in the dust of %s's MetaCoin\u2122 mining speed", "%s was outpaced by %s's MetaCoin\u2122 production level", "%s was left in awe of %s's MetaCoin\u2122 reliability level", "%s was left penniless by %s's MetaCoin\u2122 fortune", "%s was left in ruins by %s's MetaCoin\u2122 revolution", "%s was left speechless by %s's MetaCoin\u2122 extravagance", "%s was left in the shadow of %s's MetaCoin\u2122 empire", "%s was left in the past by %s's MetaCoin\u2122 future", "%s was left in the dark by %s's MetaCoin\u2122 enlightenment", "%s was left in the cold by %s's MetaCoin\u2122 warmth", "%s was left in the silence by %s's MetaCoin\u2122 noise", "%s was left in the chaos by %s's MetaCoin\u2122 order");
    private static final List<String> BLOCK_CAUSED_DEATH_MESSAGES = List.of("%s was consumed by the blockchain's insatiable hunger", "%s was crushed by the weight of a rogue MetaCoin\u2122", "%s was swallowed by a MetaCoin\u2122 mining sinkhole", "%s was vaporized by a MetaCoin\u2122 Miner\u2122 meltdown", "%s was lost in the infinite loop of a MetaCoin\u2122 transaction", "%s was overwhelmed by the sheer magnitude of the MetaCoin\u2122 blockchain", "%s was caught in the explosion of a MetaCoin\u2122 Miner\u2122", "%s was bankrupted by a sudden MetaCoin\u2122 market crash", "%s was left in the dust of a MetaCoin\u2122 mining operation", "%s was outpaced by the speed of a MetaCoin\u2122 transaction", "%s was left in awe of the size of the MetaCoin\u2122 blockchain", "%s was left penniless by a MetaCoin\u2122 heist", "%s was left in ruins by a MetaCoin\u2122 revolution", "%s was left speechless by the extravagance of a MetaCoin\u2122", "%s was left in the shadow of a towering MetaCoin\u2122 Miner\u2122", "%s was left in the past by the future of MetaCoin\u2122", "%s was left in the dark by the enlightenment of MetaCoin\u2122", "%s was left in the cold by the warmth of MetaCoin\u2122", "%s was left in the silence by the noise of MetaCoin\u2122", "%s was left in the chaos by the order of MetaCoin\u2122");

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDispenserFire(BlockPreDispenseEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!(SlimefunItem.getByItem((ItemStack)itemStack) instanceof MetaCoinItem)) {
            return;
        }
        Block block = event.getBlock();
        ItemStack snowballStack = itemStack.asQuantity(1);
        event.setCancelled(true);
        itemStack.subtract();
        BlockState blockState = block.getState();
        if (blockState instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)blockState;
            blockState = block.getBlockData();
            if (blockState instanceof Directional) {
                Directional directional = (Directional)blockState;
                BlockFace blockFace = directional.getFacing();
                block.getWorld().spawn(block.getLocation().clone().add(0.5, 0.5, 0.5).add(blockFace.getDirection()), Snowball.class, snowball -> {
                    snowball.setItem(snowballStack);
                    snowball.setShooter((ProjectileSource)dispenser.getBlockProjectileSource());
                    snowball.setVelocity(blockFace.getDirection().add(new Vector(0.0, 0.1, 0.0)).multiply(1.1).multiply(new Vector(RandomUtils.randomDouble(0.9, 1.1), RandomUtils.randomDouble(0.9, 1.1), RandomUtils.randomDouble(0.9, 1.1))));
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        ThrowableProjectile projectile;
        Projectile projectile2 = event.getEntity();
        if (!(projectile2 instanceof ThrowableProjectile) || PersistentDataAPI.hasBoolean((PersistentDataHolder)(projectile = (ThrowableProjectile)projectile2), Keys.flippingCoin) || !((projectile2 = SlimefunItem.getByItem((ItemStack)projectile.getItem())) instanceof MetaCoinItem)) {
            return;
        }
        MetaCoinItem coin = (MetaCoinItem)projectile2;
        Entity entity = event.getHitEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof Merchant) {
            Merchant merchant = (Merchant)entity;
            if (!((Boolean)coin.getAllowTrading().getValue()).booleanValue() || merchant.getRecipeCount() < 1) {
                return;
            }
            MerchantRecipe recipe = (MerchantRecipe)RandomUtils.randomChoice(merchant.getRecipes());
            entity.getWorld().dropItemNaturally(entity.getLocation(), recipe.getResult());
            return;
        }
        if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            if (!((Boolean)coin.getAllowTrading().getValue()).booleanValue()) {
                return;
            }
            Collection drops = LootTables.PIGLIN_BARTERING.getLootTable().populateLoot(Utils.RANDOM, new LootContext.Builder(entity.getLocation()).lootedEntity((Entity)piglin).build());
            ItemStack drop = (ItemStack)RandomUtils.randomChoice(new ArrayList(drops));
            entity.getWorld().dropItemNaturally(entity.getLocation(), drop);
            return;
        }
        if (entity instanceof LivingEntity) {
            ThrowableProjectile throwableProjectile;
            LivingEntity livingEntity = (LivingEntity)entity;
            DamageSource.Builder source = DamageSource.builder((DamageType)DamageType.MOB_PROJECTILE);
            ProjectileSource projectileSource = projectile.getShooter();
            if (projectileSource instanceof Entity) {
                Entity shooter = (Entity)projectileSource;
                throwableProjectile = shooter;
            } else {
                throwableProjectile = projectile;
            }
            source.withCausingEntity((Entity)throwableProjectile);
            source.withDirectEntity((Entity)projectile);
            livingEntity.damage(((Double)coin.getDamage().getValue()).doubleValue(), source.build());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (player.getLastDamageCause() == null) {
            return;
        }
        DamageSource damageSource = player.getLastDamageCause().getDamageSource();
        Entity entity = damageSource.getCausingEntity();
        if (entity instanceof Player) {
            Snowball snowball;
            Player damager = (Player)entity;
            entity = damageSource.getDirectEntity();
            if (entity instanceof Snowball && SlimefunItem.getByItem((ItemStack)(snowball = (Snowball)entity).getItem()) instanceof MetaCoinItem) {
                event.setDeathMessage(RandomUtils.randomChoice(PLAYER_CAUSED_DEATH_MESSAGES).formatted(player.getName(), damager.getName()));
                return;
            }
        }
        if (!(damageSource.getCausingEntity() instanceof Snowball)) return;
        entity = damageSource.getDirectEntity();
        if (!(entity instanceof Snowball)) return;
        Snowball snowball = (Snowball)entity;
        if (!(SlimefunItem.getByItem((ItemStack)snowball.getItem()) instanceof MetaCoinItem)) return;
        event.setDeathMessage(RandomUtils.randomChoice(BLOCK_CAUSED_DEATH_MESSAGES).formatted(player.getName()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRemoved(EntityRemoveFromWorldEvent event) {
        ThrowableProjectile projectile;
        Entity entity = event.getEntity();
        if (entity instanceof ThrowableProjectile && PersistentDataAPI.hasBoolean((PersistentDataHolder)(projectile = (ThrowableProjectile)entity), Keys.flippingCoin) && (entity = SlimefunItem.getByItem((ItemStack)projectile.getItem())) instanceof MetaCoinItem) {
            MetaCoinItem coin = (MetaCoinItem)entity;
            entity = projectile.getShooter();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                coin.sendFlipResult(player);
                PersistentDataAPI.remove((PersistentDataHolder)player, Keys.flippingCoin);
            }
        }
    }
}

