/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.displaymodellib.builders.BlockDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;
import org.metamechanists.displaymodellib.transformations.TransformationUtils;

public class ModelLine
implements ModelComponent {
    private final BlockDisplayBuilder main = new BlockDisplayBuilder();
    private Vector3f from = new Vector3f();
    private Vector3f to = new Vector3f();
    private float thickness;
    private float extraLength;
    private double roll;

    public ModelLine from(Vector3f from) {
        this.from = from;
        return this;
    }

    public ModelLine from(float x, float y, float z) {
        return this.from(new Vector3f(x, y, z));
    }

    public ModelLine to(Vector3f to) {
        this.to = to;
        return this;
    }

    public ModelLine to(float x, float y, float z) {
        return this.to(new Vector3f(x, y, z));
    }

    public ModelLine thickness(float thickness) {
        this.thickness = thickness;
        return this;
    }

    public ModelLine extraLength(float extraLength) {
        this.extraLength = extraLength;
        return this;
    }

    public ModelLine roll(double roll) {
        this.roll = this.extraLength;
        return this;
    }

    public ModelLine block(@NotNull BlockData block) {
        this.main.blockData(block);
        return this;
    }

    public ModelLine material(@NotNull Material material) {
        this.main.material(material);
        return this;
    }

    public ModelLine brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelLine glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        Vector3f midpoint = TransformationUtils.getMidpoint(this.from, this.to);
        return new TransformationMatrixBuilder().translate(midpoint).lookAlong(this.from, this.to).rotate(0.0, 0.0, this.roll).scale(new Vector3f(this.thickness, this.thickness, this.from.distance((Vector3fc)this.to) + this.extraLength)).buildForBlockDisplay();
    }

    public BlockDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public BlockDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public BlockDisplayBuilder getMain() {
        return this.main;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public float getThickness() {
        return this.thickness;
    }

    public float getExtraLength() {
        return this.extraLength;
    }

    public double getRoll() {
        return this.roll;
    }
}

