/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.metamechanists.displaymodellib.builders.BlockDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelAdvancedCuboid
implements ModelComponent {
    private final BlockDisplayBuilder main = new BlockDisplayBuilder();
    private final TransformationMatrixBuilder matrixBuilder = new TransformationMatrixBuilder();

    public ModelAdvancedCuboid translate(@NotNull Vector3f translation) {
        this.matrixBuilder.translate(translation);
        return this;
    }

    public ModelAdvancedCuboid translate(float x, float y, float z) {
        return this.translate(new Vector3f(x, y, z));
    }

    public ModelAdvancedCuboid facing(@NotNull Vector3f facing) {
        this.matrixBuilder.lookAlong(facing);
        return this;
    }

    public ModelAdvancedCuboid facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelAdvancedCuboid scale(@NotNull Vector3f size) {
        this.matrixBuilder.scale(size);
        return this;
    }

    public ModelAdvancedCuboid scale(float x, float y, float z) {
        return this.scale(new Vector3f(x, y, z));
    }

    public ModelAdvancedCuboid scale(float size) {
        return this.scale(new Vector3f(size));
    }

    public ModelAdvancedCuboid rotate(@NotNull Vector3d rotation) {
        this.matrixBuilder.rotate(rotation);
        return this;
    }

    public ModelAdvancedCuboid rotate(double x, double y, double z) {
        return this.rotate(new Vector3d(x, y, z));
    }

    public ModelAdvancedCuboid rotate(double rotationY) {
        return this.rotate(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelAdvancedCuboid rotateBackwards(@NotNull Vector3d rotation) {
        this.matrixBuilder.rotateBackwards(rotation);
        return this;
    }

    public ModelAdvancedCuboid rotateBackwards(double x, double y, double z) {
        return this.rotateBackwards(new Vector3d(x, y, z));
    }

    public ModelAdvancedCuboid rotateBackwards(double rotationY) {
        return this.rotateBackwards(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelAdvancedCuboid material(@NotNull Material material) {
        this.main.material(material);
        return this;
    }

    public ModelAdvancedCuboid block(@NotNull BlockData block) {
        this.main.blockData(block);
        return this;
    }

    public ModelAdvancedCuboid brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelAdvancedCuboid glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        return this.matrixBuilder.buildForBlockDisplay();
    }

    public BlockDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public BlockDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public BlockDisplayBuilder getMain() {
        return this.main;
    }

    public TransformationMatrixBuilder getMatrixBuilder() {
        return this.matrixBuilder;
    }
}

