/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.displaymodellib.Utils;
import org.metamechanists.displaymodellib.builders.ItemDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelItem
implements ModelComponent {
    private final ItemDisplayBuilder main = new ItemDisplayBuilder();
    private Vector3f location = new Vector3f();
    private Vector3f facing = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f size = new Vector3f();
    private Vector3d rotation = new Vector3d();

    public ModelItem location(@NotNull Vector3f location) {
        this.location = location;
        return this;
    }

    public ModelItem location(float x, float y, float z) {
        return this.location(new Vector3f(x, y, z));
    }

    public ModelItem facing(@NotNull Vector3f facing) {
        this.facing = facing;
        return this;
    }

    public ModelItem facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelItem size(float size) {
        this.size = new Vector3f(size);
        return this;
    }

    public ModelItem rotation(@NotNull Vector3d rotation) {
        this.rotation = rotation;
        return this;
    }

    public ModelItem rotation(double x, double y, double z) {
        return this.rotation(new Vector3d(x, y, z));
    }

    public ModelItem rotation(double rotationY) {
        return this.rotation(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelItem item(@NotNull ItemStack itemStack) {
        this.main.itemStack(itemStack);
        return this;
    }

    public ModelItem material(@NotNull Material material) {
        this.main.material(material);
        return this;
    }

    public ModelItem brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelItem glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    public ModelItem billboard(@NotNull Display.Billboard billboard) {
        this.main.billboard(billboard);
        return this;
    }

    public ModelItem viewRange(int viewRange) {
        this.main.viewRange(viewRange);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        Vector3d adjustedRotation = this.rotation;
        if (Utils.getMajorServerVersion() >= 20) {
            adjustedRotation = new Vector3d((Vector3dc)this.rotation).add(Math.PI, Math.PI, Math.PI);
        }
        return new TransformationMatrixBuilder().lookAlong(this.facing).translate(this.location).rotate(adjustedRotation).scale(new Vector3f((Vector3fc)this.size)).buildForItemDisplay();
    }

    public ItemDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public ItemDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public ItemDisplayBuilder getMain() {
        return this.main;
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getFacing() {
        return this.facing;
    }

    public Vector3f getSize() {
        return this.size;
    }

    public Vector3d getRotation() {
        return this.rotation;
    }
}

