/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.dough.recipes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;
import org.metamechanists.metacoin.metalib.dough.recipes.MinecraftRecipe;

public class RecipeSnapshot {
    private final Map<Class<? extends Recipe>, Set<Recipe>> recipes = new HashMap<Class<? extends Recipe>, Set<Recipe>>();
    private final Map<NamespacedKey, Recipe> keyedRecipes = new HashMap<NamespacedKey, Recipe>();

    public RecipeSnapshot(@Nonnull Plugin plugin) {
        Iterator iterator = plugin.getServer().recipeIterator();
        plugin.getLogger().log(Level.INFO, "Collecting Snapshots of all Recipes...");
        while (iterator.hasNext()) {
            Recipe recipe = null;
            try {
                recipe = (Recipe)iterator.next();
                Set set = this.recipes.computeIfAbsent(recipe.getClass(), key -> new LinkedHashSet());
                set.add(recipe);
                if (!(recipe instanceof Keyed)) continue;
                this.keyedRecipes.put(((Keyed)recipe).getKey(), recipe);
            }
            catch (Exception x) {
                plugin.getLogger().log(Level.WARNING, "Skipped a faulty recipe of unknown source ({0}): {1}", new Object[]{x.getClass().getSimpleName(), x.getMessage()});
            }
        }
        plugin.getLogger().log(Level.INFO, "Found {0} Recipes!", this.recipes.entrySet().stream().mapToInt(entry -> ((Set)entry.getValue()).size()).sum());
    }

    @Nonnull
    public Stream<Recipe> streamAllRecipes() {
        return this.recipes.values().stream().flatMap(Collection::stream);
    }

    @Nonnull
    public <T extends Recipe> Set<T> getRecipes(@Nonnull Class<T> recipeClass) {
        return this.stream(recipeClass).collect(Collectors.toSet());
    }

    @Nonnull
    public <T extends Recipe> Stream<T> stream(@Nonnull Class<T> recipeClass) {
        return this.recipes.entrySet().stream().filter(entry -> recipeClass.isAssignableFrom((Class)entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).map(recipeClass::cast);
    }

    @Nonnull
    public <T extends Recipe> RecipeChoice[] getRecipeInput(@Nonnull MinecraftRecipe<? super T> recipeType, @Nonnull T recipe) {
        return recipeType.getInputs(recipe);
    }

    @Nonnull
    public <T extends Recipe> RecipeChoice[] getRecipeInput(@Nonnull T recipe) {
        Optional<MinecraftRecipe<T>> type = MinecraftRecipe.of(recipe);
        if (type.isPresent()) {
            return this.getRecipeInput(type.get(), recipe);
        }
        return new RecipeChoice[0];
    }

    @Nonnull
    public <T extends Recipe> Optional<ItemStack> getRecipeOutput(@Nonnull MinecraftRecipe<T> recipeType, ItemStack ... inputs) {
        if (recipeType.validate(inputs)) {
            return recipeType.getOutput(this.stream(recipeType.getRecipeClass()), inputs);
        }
        return Optional.empty();
    }

    @Nonnull
    public Set<Recipe> getRecipes(@Nonnull Predicate<Recipe> predicate) {
        return this.streamAllRecipes().filter(predicate).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<Recipe> getRecipesFor(@Nonnull Material type) {
        return this.getRecipes((Recipe recipe) -> recipe.getResult().getType() == type);
    }

    @Nonnull
    public Set<Recipe> getRecipesFor(@Nonnull ItemStack item) {
        return this.getRecipes((Recipe recipe) -> recipe.getResult().isSimilar(item));
    }

    @Nonnull
    public Set<Recipe> getRecipesWith(@Nonnull ItemStack item) {
        return this.getRecipes((Recipe recipe) -> Arrays.stream(this.getRecipeInput(recipe)).anyMatch(choice -> choice.test(item)));
    }

    @Nullable
    public Recipe getRecipe(@Nonnull NamespacedKey key) {
        return this.keyedRecipes.get(key);
    }
}

