/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.builders;

import org.bukkit.Location;
import org.bukkit.entity.Interaction;
import org.jetbrains.annotations.NotNull;

public class InteractionBuilder {
    private Float width;
    private Float height;

    public Interaction build(@NotNull Location location) {
        Location finalLocation = location.clone();
        if (this.height != null) {
            finalLocation.subtract(0.0, (double)(this.height.floatValue() / 2.0f), 0.0);
        }
        return (Interaction)location.getWorld().spawn(finalLocation, Interaction.class, interaction -> {
            if (this.width != null) {
                interaction.setInteractionWidth(this.width.floatValue());
            }
            if (this.height != null) {
                interaction.setInteractionHeight(this.height.floatValue());
            }
        });
    }

    public InteractionBuilder width(float width) {
        this.width = Float.valueOf(width);
        return this;
    }

    public InteractionBuilder height(float height) {
        this.height = Float.valueOf(height);
        return this;
    }
}

