/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.utils;

import org.bukkit.block.Block;
import org.metamechanists.metacoin.metalib.interfaces.BlockRunnable;

public class RadiusUtils {
    public static void forEachSquareRadius(Block centerBlock, int radius, BlockRunnable runnable) {
        RadiusUtils.forEachRectangularRadius(centerBlock, radius, radius, runnable);
    }

    public static void forEachRectangularRadius(Block centerBlock, int xRadius, int zRadius, BlockRunnable runnable) {
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                if (!runnable.run(centerBlock.getRelative(x, 0, z))) continue;
                return;
            }
        }
    }

    public static void forEachCircleRadius(Block centerBlock, int radius, BlockRunnable runnable) {
        RadiusUtils.forEachSquareRadius(centerBlock, radius, block -> {
            if (centerBlock.getLocation().distanceSquared(block.getLocation()) > Math.pow(radius, 2.0)) {
                return false;
            }
            return runnable.run(block);
        });
    }

    public static void forEachCubeRadius(Block centerBlock, int radius, BlockRunnable runnable) {
        RadiusUtils.forEachRectangularPrismRadius(centerBlock, radius, radius, radius, runnable);
    }

    public static void forEachRectangularPrismRadius(Block centerBlock, int xRadius, int yRadius, int zRadius, BlockRunnable runnable) {
        RadiusUtils.forEachRectangularRadius(centerBlock, xRadius, zRadius, block -> {
            for (int y = -yRadius; y <= yRadius; ++y) {
                if (!runnable.run(block.getRelative(0, y, 0))) continue;
                return true;
            }
            return false;
        });
    }

    public static void forEachSphereRadius(Block centerBlock, int radius, BlockRunnable runnable) {
        RadiusUtils.forEachCubeRadius(centerBlock, radius, block -> {
            if (centerBlock.getLocation().distanceSquared(block.getLocation()) > Math.pow(radius, 2.0)) {
                return false;
            }
            return runnable.run(block);
        });
    }
}

