/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.dough.items;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemMetaSnapshot {
    private final Optional<String> displayName;
    private final Optional<List<String>> lore;
    private final OptionalInt customModelData;
    private final Set<ItemFlag> itemFlags;
    private final Map<Enchantment, Integer> enchantments;

    public ItemMetaSnapshot(@Nonnull ItemStack item) {
        this(item.getItemMeta());
    }

    public ItemMetaSnapshot(@Nonnull Supplier<ItemMeta> supplier) {
        this(supplier.get());
    }

    public ItemMetaSnapshot(@Nonnull ItemMeta meta) {
        this.displayName = meta.hasDisplayName() ? Optional.of(meta.getDisplayName()) : Optional.empty();
        this.lore = meta.hasLore() ? Optional.of(Collections.unmodifiableList(meta.getLore())) : Optional.empty();
        this.customModelData = meta.hasCustomModelData() ? OptionalInt.of(meta.getCustomModelData()) : OptionalInt.empty();
        this.itemFlags = meta.getItemFlags();
        this.enchantments = meta.getEnchants();
    }

    @Nonnull
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public Optional<List<String>> getLore() {
        return this.lore;
    }

    @Nonnull
    public OptionalInt getCustomModelData() {
        return this.customModelData;
    }

    @Nonnull
    public Set<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    @Nonnull
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public boolean isSimilar(@Nonnull ItemMetaSnapshot snapshot) {
        if (snapshot.displayName.isPresent() != this.displayName.isPresent()) {
            return false;
        }
        if (snapshot.displayName.isPresent() && this.displayName.isPresent() && !snapshot.displayName.get().equals(this.displayName.get())) {
            return false;
        }
        if (snapshot.lore.isPresent() && this.lore.isPresent()) {
            return this.lore.get().equals(snapshot.lore.get());
        }
        return !snapshot.lore.isPresent() && !this.lore.isPresent();
    }

    public boolean isSimilar(@Nonnull ItemMeta meta) {
        boolean hasDisplayName = meta.hasDisplayName();
        if (hasDisplayName != this.displayName.isPresent()) {
            return false;
        }
        if (hasDisplayName && this.displayName.isPresent() && !meta.getDisplayName().equals(this.displayName.get())) {
            return false;
        }
        boolean hasLore = meta.hasLore();
        if (hasLore && this.lore.isPresent()) {
            return this.lore.get().equals(meta.getLore());
        }
        return !hasLore && !this.lore.isPresent();
    }
}

