/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.slimefun;

import io.github.bakedlibs.dough.blocks.BlockPosition;
import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.displaymodellib.models.ModelBuilder;
import org.metamechanists.metacoin.core.ItemStacks;
import org.metamechanists.metacoin.core.Models;
import org.metamechanists.metacoin.core.Statistics;
import org.metamechanists.metacoin.implementation.runnables.WarrantyVoidRunnable;
import org.metamechanists.metacoin.implementation.slimefun.DisplayModelBlock;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinItem;
import org.metamechanists.metacoin.implementation.slimefun.Upgrades;
import org.metamechanists.metacoin.metalib.utils.ItemUtils;
import org.metamechanists.metacoin.metalib.utils.ParticleUtils;
import org.metamechanists.metacoin.metalib.utils.RandomUtils;
import org.metamechanists.metacoin.utils.Keys;
import org.metamechanists.metacoin.utils.Language;
import org.metamechanists.metacoin.utils.Utils;

public class MetaCoinMiner
extends DisplayModelBlock {
    private static final int[] SPEED_DISPLAY = new int[]{0, 1, 2, 36, 37, 38};
    private static final int[] PRODUCTION_DISPLAY = new int[]{3, 4, 5, 39, 40, 41};
    private static final int[] RELIABILITY_DISPLAY = new int[]{6, 7, 8, 42, 43, 44};
    private static final int[] BOTTOM_BACKGROUND = new int[]{45, 47, 48, 49, 50, 51, 53};
    private static final int PAGE_BACK = 46;
    private static final int PAGE_FORWARD = 52;
    private static final int[] MINER_PROGRESS = new int[]{10, 11, 12, 13, 14, 15, 16, 20, 21, 22, 23, 24, 30, 31, 32, 40};
    private static final int[] MINER_BACKGROUND = new int[]{9, 17, 18, 19, 25, 26, 27, 28, 29, 33, 34, 35};
    private static final int MINER_OUTPUT = 49;
    private static final int UPGRADE_SPEED = 19;
    private static final int UPGRADE_PRODUCTION = 22;
    private static final int UPGRADE_RELIABILITY = 25;
    private static final List<Integer> ALL_CORES = IntStream.range(9, 36).boxed().toList();
    private static final List<Integer> SPEED_CORES = List.of(Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(18), Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(27), Integer.valueOf(28), Integer.valueOf(29));
    private static final List<Integer> PRODUCTION_CORES = List.of(Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(30), Integer.valueOf(31), Integer.valueOf(32));
    private static final List<Integer> RELIABILITY_CORES = List.of(Integer.valueOf(15), Integer.valueOf(16), Integer.valueOf(17), Integer.valueOf(24), Integer.valueOf(25), Integer.valueOf(26), Integer.valueOf(33), Integer.valueOf(34), Integer.valueOf(35));
    private static final Map<BlockPosition, Integer> PROGRESS = new HashMap<BlockPosition, Integer>();
    private static final Map<BlockPosition, UUID> ACCESSING_CONTROL_PANEL = new HashMap<BlockPosition, UUID>();
    private static final Set<BlockPosition> MALFUNCTIONING = new HashSet<BlockPosition>();
    private static final int TICKS_PER_PROGRESS = 4;

    public MetaCoinMiner(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, RecipeType.NULL, new ItemStack[0]);
        this.buildPreset();
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block miner, SlimefunItem slimefunItem, Config config) {
                BlockPosition minerPosition = new BlockPosition(miner);
                Location minerLocation = miner.getLocation();
                int[] levels = Upgrades.getLevels(minerLocation);
                int[] realLevels = new int[]{levels[0] - 1, levels[1] - 1, levels[2] - 1};
                if (!MALFUNCTIONING.contains(minerPosition) && RandomUtils.chance(Math.max(1, realLevels[0] + realLevels[1] - 2 * realLevels[2]))) {
                    MetaCoinMiner.this.malfunction(minerLocation, realLevels);
                }
                MetaCoinMiner.this.tick(minerLocation, minerPosition, levels);
            }
        }});
    }

    public void postRegister() {
        this.setHidden(true);
    }

    public void buildPreset() {
        new BlockMenuPreset(this.getId(), "&fMetaMiner\u2122 - Drill\u2122"){

            public void init() {
                MetaCoinMiner.this.setupMenu((ChestMenu)this, 1);
                this.drawBackground(MINER_BACKGROUND);
                this.drawBackground(ItemStacks.MINER_PROGRESS_FALSE, MINER_PROGRESS);
                this.addItem(49, ItemStacks.coinDisplay(0L), (o1, o2, o3, o4) -> false);
                this.setPlayerInventoryClickable(false);
            }

            @ParametersAreNonnullByDefault
            public boolean canOpen(Block block, Player player) {
                return player.getUniqueId().equals(MetaCoinMiner.getOwner(block));
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }

            @ParametersAreNonnullByDefault
            public void newInstance(BlockMenu menu, Block miner) {
                Location minerLocation = miner.getLocation();
                menu.addMenuOpeningHandler(player -> {
                    BlockStorage.addBlockInfo((Block)miner, (String)"LAST_MENU", (String)"MINER");
                    MetaCoinMiner.this.updateMenu(menu, new BlockPosition(miner));
                });
                menu.addMenuClickHandler(49, (player, o2, o3, o4) -> {
                    ItemUtils.addOrDropItem(player, MetaCoinItem.withTotalValue(ItemStacks.getCoinValue(menu.getItemInSlot(49))));
                    menu.replaceExistingItem(49, ItemStacks.coinDisplay(0L));
                    MetaCoinMiner.this.setCoinCache(minerLocation, 0L);
                    return false;
                });
                menu.addMenuClickHandler(52, (player, o2, o3, o4) -> {
                    BlockStorage.addBlockInfo((Block)miner, (String)"LAST_MENU", (String)"UPGRADES");
                    MetaCoinMiner.this.openUpgrades(player, menu, minerLocation);
                    return false;
                });
            }
        };
    }

    @Override
    protected void onBlockPlace(@NotNull BlockPlaceEvent event) {
        super.onBlockPlace(event);
        Block block = event.getBlock();
        Player player = event.getPlayer();
        PersistentDataAPI.setBoolean((PersistentDataHolder)player, Keys.minerPlaced, true);
        BlockStorage.addBlockInfo((Block)block, (String)"OWNER", (String)player.getUniqueId().toString());
        Upgrades.setLevels(block.getLocation(), event.getItemInHand());
    }

    public void malfunction(Location miner, int[] levels) {
        Player player;
        ArrayList<Integer> enabledCores = new ArrayList<Integer>(ALL_CORES);
        ArrayList<Integer> disabledCores = new ArrayList<Integer>();
        if (!this.getDisabledCores(miner).isEmpty()) {
            return;
        }
        for (int i = 0; i < Math.max(1, levels[0] + levels[1] - 2 * levels[2]) && !enabledCores.isEmpty(); ++i) {
            Integer core = RandomUtils.randomChoice(enabledCores);
            enabledCores.remove(core);
            disabledCores.add(core);
        }
        this.setDisabledCores(miner, disabledCores);
        UUID uuid = ACCESSING_CONTROL_PANEL.remove(new BlockPosition(miner));
        if (uuid != null && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            Slimefun.runSync(() -> {
                player.closeInventory();
                this.openControlPanel(player, BlockStorage.getInventory((Location)miner), miner);
            });
        }
    }

    public void tick(Location minerLocation, BlockPosition minerPosition, int[] levels) {
        boolean speedMalfunction;
        List<Integer> disabledCores;
        if (Utils.WARRANTIES_VOIDED) {
            this.setDisabledCores(minerLocation, new ArrayList<Integer>(ALL_CORES));
            this.malfunctionTick(minerLocation);
            return;
        }
        BlockMenu menu = BlockStorage.getInventory((Location)minerLocation);
        if (menu == null) {
            return;
        }
        long coinCache = this.getCoinCache(minerLocation);
        if (coinCache > 0L && ItemStacks.getCoinValue(menu.getItemInSlot(49)) <= 0L) {
            menu.replaceExistingItem(49, ItemStacks.coinDisplay(coinCache));
        }
        boolean malfunctioning = !(disabledCores = this.getDisabledCores(minerLocation)).isEmpty();
        boolean reliabilityMalfunction = malfunctioning && Utils.containsAny(disabledCores, RELIABILITY_CORES);
        boolean productionMalfunction = malfunctioning && (Utils.containsAny(disabledCores, PRODUCTION_CORES) || reliabilityMalfunction);
        boolean bl = speedMalfunction = malfunctioning && (Utils.containsAny(disabledCores, SPEED_CORES) || reliabilityMalfunction);
        if (malfunctioning) {
            MALFUNCTIONING.add(minerPosition);
            this.malfunctionTick(minerLocation);
        } else {
            MALFUNCTIONING.remove(minerPosition);
        }
        int progress = PROGRESS.getOrDefault(minerPosition, 0);
        if (progress < MINER_PROGRESS.length * 4) {
            PROGRESS.put(minerPosition, progress + (speedMalfunction ? 1 : levels[0]));
            this.updateMenu(BlockStorage.getInventory((Location)minerLocation), minerPosition);
            return;
        }
        PROGRESS.put(minerPosition, 0);
        this.updateMenu(menu, minerPosition);
        long production = productionMalfunction ? 1L : MetaCoinItem.valueFromProductionLevel(levels[1]);
        menu.replaceExistingItem(49, ItemStacks.coinDisplay(menu.getItemInSlot(49), production));
        this.setCoinCache(minerLocation, ItemStacks.getCoinValue(menu.getItemInSlot(49)));
        Statistics.addMinedMetaCoins(production);
    }

    public void malfunctionTick(Location miner) {
        ParticleUtils.randomParticle(miner.toCenterLocation(), Particle.CAMPFIRE_SIGNAL_SMOKE, 0.5, RandomUtils.randomInteger(1, 3));
        ParticleUtils.randomParticle(miner.toCenterLocation(), Particle.LAVA, 0.5, RandomUtils.randomInteger(1, 3));
        Slimefun.runSync(() -> miner.getWorld().playSound(miner.toCenterLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 0.1f, ThreadLocalRandom.current().nextFloat(0.1f, 1.0f)));
    }

    public void updateMenu(BlockMenu menu, BlockPosition miner) {
        if (menu == null || !menu.hasViewer()) {
            return;
        }
        int index = 1;
        int progress = PROGRESS.getOrDefault(miner, 0);
        for (int slot : MINER_PROGRESS) {
            menu.replaceExistingItem(slot, index * 4 > progress ? ItemStacks.MINER_PROGRESS_FALSE : ItemStacks.MINER_PROGRESS_TRUE);
            ++index;
        }
    }

    @Override
    protected void onBlockUse(@NotNull PlayerRightClickEvent event) {
        Player player = event.getPlayer();
        Block miner = event.getClickedBlock().orElse(null);
        if (player.isSneaking() || miner == null) {
            return;
        }
        event.setUseBlock(Event.Result.DENY);
        if (!player.getUniqueId().equals(MetaCoinMiner.getOwner(miner))) {
            Language.sendMessage(player, "miner.error.no-permission", new Object[0]);
            return;
        }
        if (Utils.WARRANTIES_VOIDED) {
            if (!WarrantyVoidRunnable.isVoided(miner)) {
                new WarrantyVoidRunnable(player, miner, this.getDisplayGroup(miner));
            }
            return;
        }
        Location minerLocation = miner.getLocation();
        BlockMenu minerMenu = BlockStorage.getInventory((Block)miner);
        String lastMenu = BlockStorage.getLocationInfo((Location)miner.getLocation(), (String)"LAST_MENU");
        if (lastMenu == null) {
            minerMenu.open(new Player[]{player});
            return;
        }
        switch (lastMenu) {
            case "UPGRADES": {
                this.openUpgrades(player, minerMenu, minerLocation);
                break;
            }
            case "CONTROL_PANEL": {
                this.openControlPanel(player, minerMenu, minerLocation);
                break;
            }
            default: {
                minerMenu.open(new Player[]{player});
            }
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBlockBreak(BlockBreakEvent event, ItemStack itemStack, List<ItemStack> drops) {
        super.onBlockBreak(event, itemStack, drops);
        Player player = event.getPlayer();
        Block miner = event.getBlock();
        Location minerLocation = miner.getLocation();
        event.setDropItems(false);
        miner.getWorld().dropItemNaturally(minerLocation, ItemStacks.metaCoinMiner(player, Upgrades.getLevels(minerLocation)));
        PersistentDataAPI.setBoolean((PersistentDataHolder)player, Keys.minerPlaced, false);
        BlockMenu menu = BlockStorage.getInventory((Block)miner);
        if (menu != null) {
            for (ItemStack coin : MetaCoinItem.withTotalValue(ItemStacks.getCoinValue(menu.getItemInSlot(49)))) {
                miner.getWorld().dropItemNaturally(minerLocation, coin);
            }
        }
    }

    public void openUpgrades(Player player, BlockMenu minerMenu, Location miner) {
        ChestMenu menu = this.setupMenu("Upgrades", 2);
        menu.addMenuClickHandler(46, (o1, o2, o3, o4) -> {
            minerMenu.open(new Player[]{player});
            return false;
        });
        menu.addMenuClickHandler(52, (o1, o2, o3, o4) -> {
            BlockStorage.addBlockInfo((Location)miner, (String)"LAST_MENU", (String)"CONTROL_PANEL");
            this.openControlPanel(player, minerMenu, miner);
            return false;
        });
        menu.addItem(19, Upgrades.SPEED.getDisplay(miner), Upgrades.SPEED.getClickHandler(menu, miner));
        menu.addItem(22, Upgrades.PRODUCTION.getDisplay(miner), Upgrades.PRODUCTION.getClickHandler(menu, miner));
        menu.addItem(25, Upgrades.RELIABILITY.getDisplay(miner), Upgrades.RELIABILITY.getClickHandler(menu, miner));
        menu.open(new Player[]{player});
    }

    public void openControlPanel(Player player, BlockMenu minerMenu, Location miner) {
        ChestMenu menu = this.setupMenu("Control Panel", 3);
        menu.addMenuClickHandler(46, (o1, o2, o3, o4) -> {
            BlockStorage.addBlockInfo((Location)miner, (String)"LAST_MENU", (String)"UPGRADES");
            this.openUpgrades(player, minerMenu, miner);
            return false;
        });
        List<Integer> disabledCores = this.getDisabledCores(miner);
        this.addCores(miner, menu, SPEED_CORES, "Speed", "&e", disabledCores);
        this.addCores(miner, menu, PRODUCTION_CORES, "Production", "&b", disabledCores);
        this.addCores(miner, menu, RELIABILITY_CORES, "Reliability", "&d", disabledCores);
        menu.addMenuCloseHandler(o1 -> ACCESSING_CONTROL_PANEL.remove(new BlockPosition(miner)));
        menu.open(new Player[]{player});
        ACCESSING_CONTROL_PANEL.put(new BlockPosition(miner), player.getUniqueId());
    }

    public void addCores(Location miner, ChestMenu menu, List<Integer> cores, String type, String color, List<Integer> disabledCores) {
        int index = 1;
        for (Integer coreSlot : cores) {
            int currentIndex = index;
            menu.addItem(coreSlot.intValue(), ItemStacks.core(type, color, currentIndex, !disabledCores.contains(coreSlot)));
            menu.addMenuClickHandler(coreSlot.intValue(), (o1, o2, itemStack, o4) -> {
                boolean running;
                List<Integer> newDisabledCores = this.getDisabledCores(miner);
                boolean bl = running = itemStack.getType() == Material.LIME_STAINED_GLASS_PANE;
                if (running) {
                    newDisabledCores.add(coreSlot);
                } else {
                    newDisabledCores.remove(coreSlot);
                }
                menu.replaceExistingItem(coreSlot.intValue(), ItemStacks.core(type, color, currentIndex, !running));
                this.setDisabledCores(miner, newDisabledCores);
                return false;
            });
            ++index;
        }
    }

    public ChestMenu setupMenu(String suffix, int page) {
        ChestMenu menu = new ChestMenu("&fMetaMiner\u2122 - " + suffix + "\u2122");
        this.setupMenu(menu, page);
        return menu;
    }

    public void setupMenu(ChestMenu menu, int page) {
        Utils.drawBackground(menu, ItemStacks.SPEED_DISPLAY, SPEED_DISPLAY);
        Utils.drawBackground(menu, ItemStacks.PRODUCTION_DISPLAY, PRODUCTION_DISPLAY);
        Utils.drawBackground(menu, ItemStacks.RELIABILITY_DISPLAY, RELIABILITY_DISPLAY);
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])BOTTOM_BACKGROUND);
        menu.addItem(46, ItemStacks.pageBack(page, 3), ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(52, ItemStacks.pageForward(page, 3), ChestMenuUtils.getEmptyClickHandler());
    }

    public static UUID getOwner(Block miner) {
        String uuidString = BlockStorage.getLocationInfo((Location)miner.getLocation(), (String)"OWNER");
        if (uuidString == null) {
            return null;
        }
        try {
            return UUID.fromString(uuidString);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void setCoinCache(Location miner, long coins) {
        BlockStorage.addBlockInfo((Location)miner, (String)"COIN_CACHE", (String)String.valueOf(coins));
    }

    private long getCoinCache(Location miner) {
        try {
            return Long.parseLong(BlockStorage.getLocationInfo((Location)miner, (String)"COIN_CACHE"));
        }
        catch (Exception ignored) {
            BlockStorage.addBlockInfo((Location)miner, (String)"COIN_CACHE", (String)"0");
            return 0L;
        }
    }

    public void setDisabledCores(Location miner, List<Integer> disabledCores) {
        StringBuilder cores = new StringBuilder();
        for (int coreSlot : disabledCores) {
            if (!cores.isEmpty()) {
                cores.append(",");
            }
            cores.append(coreSlot);
        }
        BlockStorage.addBlockInfo((Location)miner, (String)"DISABLED_CORES", (String)cores.toString());
    }

    public List<Integer> getDisabledCores(Location miner) {
        String coresString = BlockStorage.getLocationInfo((Location)miner, (String)"DISABLED_CORES");
        if (coresString == null) {
            return new ArrayList<Integer>();
        }
        String[] cores = coresString.split(",");
        ArrayList<Integer> disabledCores = new ArrayList<Integer>();
        for (String core : cores) {
            try {
                disabledCores.add(Integer.parseInt(core));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return disabledCores;
    }

    @Override
    public Vector getBuildOffset() {
        return new Vector(0.5, 0.5, 0.5);
    }

    @Override
    @Nonnull
    public Material getBaseMaterial() {
        return Material.BEACON;
    }

    @Override
    public ModelBuilder getDisplayModel() {
        return Models.META_COIN_MINER();
    }
}

