/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.listeners;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockBreakEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.metamechanists.metacoin.implementation.runnables.WarrantyVoidRunnable;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinMiner;
import org.metamechanists.metacoin.utils.Keys;
import org.metamechanists.metacoin.utils.Language;

public class MinerListeners
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPickupItem(EntityPickupItemEvent event) {
        ItemStack itemStack = event.getItem().getItemStack();
        if (!(SlimefunItem.getByItem((ItemStack)itemStack) instanceof MetaCoinMiner)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.getUniqueId().toString().equals(PersistentDataAPI.getString((PersistentDataHolder)itemStack.getItemMeta(), Keys.owner))) {
            Language.sendMessage(player, "miner.error.no-permission", new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSlimefunBlockPlace(SlimefunBlockPlaceEvent event) {
        if (!(event.getSlimefunItem() instanceof MetaCoinMiner)) {
            return;
        }
        Player player = event.getPlayer();
        if (PersistentDataAPI.getOptionalBoolean((PersistentDataHolder)player, Keys.minerPlaced).orElse(false).booleanValue()) {
            Language.sendMessage(player, "miner.error.placed-already", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (!player.getUniqueId().toString().equals(PersistentDataAPI.getString((PersistentDataHolder)event.getItemStack().getItemMeta(), Keys.owner))) {
            Language.sendMessage(player, "miner.error.no-permission", new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSlimefunBlockBreak(SlimefunBlockBreakEvent event) {
        if (!(event.getSlimefunItem() instanceof MetaCoinMiner)) {
            return;
        }
        Player player = event.getPlayer();
        Block miner = event.getBlockBroken();
        if (!player.getUniqueId().equals(MetaCoinMiner.getOwner(miner))) {
            Language.sendMessage(player, "miner.error.no-permission", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (WarrantyVoidRunnable.isVoided(miner)) {
            event.setCancelled(true);
        }
    }
}

