/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.commands;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.metacoin.acf.BaseCommand;
import org.metamechanists.metacoin.acf.annotation.CommandAlias;
import org.metamechanists.metacoin.acf.annotation.CommandPermission;
import org.metamechanists.metacoin.acf.annotation.Description;
import org.metamechanists.metacoin.acf.annotation.Subcommand;
import org.metamechanists.metacoin.core.ItemStacks;
import org.metamechanists.metacoin.core.Leaderboard;
import org.metamechanists.metacoin.core.Statistics;
import org.metamechanists.metacoin.implementation.runnables.WarrantyVoidRunnable;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinItem;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinMiner;
import org.metamechanists.metacoin.implementation.slimefun.Upgrades;
import org.metamechanists.metacoin.metalib.utils.ItemUtils;
import org.metamechanists.metacoin.utils.Keys;

@CommandAlias(value="metacoin\u2122|metacoin|blockchain|\u2122")
public class MetaCoinCommand
extends BaseCommand {
    @Subcommand(value="statistics")
    @Description(value="View how MetaCoin\u2122 is getting on around the world")
    @CommandPermission(value="metacoin.command.statistics")
    public static void statistics(CommandSender sender) {
        sender.sendMessage("https://bstats.org/plugin/bukkit/MetaCoin/");
    }

    @Subcommand(value="trailer")
    @Description(value="See the trailer for this exquisite blockchain project")
    @CommandPermission(value="metacoin.command.trailer")
    public static void trailer(CommandSender sender) {
        sender.sendMessage("https://youtu.be/71UOYQNsnXE");
    }

    @Subcommand(value="deposit")
    @Description(value="Deposits your pathetically small number of coins to the leaderboard")
    @CommandPermission(value="metacoin.command.deposit")
    public static void deposit(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        long value = MetaCoinItem.getTotalCoinValue(player);
        MetaCoinItem.removeCoins(player, value);
        Leaderboard.updateLeaderboard(player.getUniqueId(), Leaderboard.getValue(player.getUniqueId()) + value);
    }

    @Subcommand(value="resetleaderboard")
    @Description(value="Resets the leaderboard, OBLITERATING all the hard work of your players")
    @CommandPermission(value="metacoin.command.resetleaderboard")
    public static void resetLeaderboard(CommandSender sender) {
        Leaderboard.reset();
    }

    @Subcommand(value="compress")
    @Description(value="Compresses all coins in your inventory using ADVANCED NANOTECHNOLOGY")
    @CommandPermission(value="metacoin.command.compress")
    public static void compress(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        long value = MetaCoinItem.getTotalCoinValue(player);
        MetaCoinItem.removeCoins(player, value);
        ItemUtils.addOrDropItem(player, MetaCoinItem.withTotalValue(value));
    }

    @Subcommand(value="invest")
    @Description(value="Start your adventure in blockchain by acquiring a MetaMiner\u2122")
    @CommandPermission(value="metacoin.command.invest")
    public static void invest(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        if (PersistentDataAPI.getOptionalBoolean((PersistentDataHolder)player, Keys.receivedMiner).orElse(false).booleanValue()) {
            player.sendMessage("You ABSOLUTE BUFFON. you cannot acquire a second MetaMiner\u2122. You had just ONCE CHANCE to redeem yourself in this life, and you failed.");
            return;
        }
        PersistentDataAPI.setBoolean((PersistentDataHolder)player, Keys.receivedMiner, true);
        ItemUtils.addOrDropItemMainHand(player, ItemStacks.metaCoinMiner(player));
        Statistics.addMetaMiner(player);
    }

    @Subcommand(value="reset")
    @Description(value="Allows a player to run /invest again to get another miner")
    @CommandPermission(value="metacoin.command.reset")
    public static void resetStuff(CommandSender sender, @NotNull Player player) {
        PersistentDataAPI.remove((PersistentDataHolder)player, Keys.minerPlaced);
        PersistentDataAPI.remove((PersistentDataHolder)player, Keys.receivedMiner);
    }

    @Subcommand(value="becomeslag")
    @Description(value="Uses the power of CRYPTOGRAPHY to turn the metaminer you're looking at into slag")
    @CommandPermission(value="metacoin.command.becomeslag")
    public static void becomeSlag(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        Block block = player.getTargetBlockExact(7);
        if (block != null && BlockStorage.check((Block)block) instanceof MetaCoinMiner) {
            ItemUtils.addOrDropItemMainHand(player, ItemStacks.machineSlag(player, Upgrades.getLevels(block.getLocation())));
        }
    }

    @Subcommand(value="voidwarranty")
    @Description(value="Uses the power of CRYPTOGRAPHY to void the warranty on the MetaMiner\u2122 you're looking at")
    @CommandPermission(value="metacoin.command.voidwarranty")
    public static void voidWarranty(CommandSender sender) {
        SlimefunItem slimefunItem;
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        Block block = player.getTargetBlockExact(7);
        if (block != null && (slimefunItem = BlockStorage.check((Block)block)) instanceof MetaCoinMiner) {
            MetaCoinMiner miner = (MetaCoinMiner)slimefunItem;
            new WarrantyVoidRunnable(player, block, miner.getDisplayGroup(block));
        }
    }
}

