/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.acf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.metamechanists.metacoin.acf.ACFBukkitUtil;
import org.metamechanists.metacoin.acf.BukkitCommandManager;

class ACFBukkitLocalesListener
implements Listener {
    private final BukkitCommandManager manager;

    ACFBukkitLocalesListener(BukkitCommandManager manager) {
        this.manager = manager;
    }

    @EventHandler
    void onLocaleChange(PlayerLocaleChangeEvent event) {
        if (!this.manager.autoDetectFromClient) {
            return;
        }
        Player player = event.getPlayer();
        Locale locale = null;
        try {
            locale = event.locale();
        }
        catch (NoSuchMethodError ignored) {
            try {
                if (!event.getLocale().equals(this.manager.issuersLocaleString.get(player.getUniqueId()))) {
                    locale = ACFBukkitUtil.stringToLocale(event.getLocale());
                }
            }
            catch (NoSuchMethodError ignored2) {
                try {
                    Method getNewLocale = event.getClass().getMethod("getNewLocale", new Class[0]);
                    getNewLocale.setAccessible(true);
                    String value = (String)getNewLocale.invoke((Object)event, new Object[0]);
                    if (!value.equals(this.manager.issuersLocaleString.get(player.getUniqueId()))) {
                        locale = ACFBukkitUtil.stringToLocale(value);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        if (locale == null) {
            return;
        }
        this.manager.setPlayerLocale(player, locale);
    }
}

