/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.displaymodellib.builders.TextDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelText
implements ModelComponent {
    private final TextDisplayBuilder main = new TextDisplayBuilder().backgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
    private Vector3f location = new Vector3f();
    private Vector3f facing = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f size = new Vector3f();
    private Vector3d rotation = new Vector3d();

    public ModelText location(@NotNull Vector3f location) {
        this.location = location;
        return this;
    }

    public ModelText location(float x, float y, float z) {
        return this.location(new Vector3f(x, y, z));
    }

    public ModelText facing(@NotNull Vector3f facing) {
        this.facing = facing;
        return this;
    }

    public ModelText facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelText size(float size) {
        this.size = new Vector3f(size);
        return this;
    }

    public ModelText rotation(@NotNull Vector3d rotation) {
        this.rotation = rotation;
        return this;
    }

    public ModelText rotation(double x, double y, double z) {
        return this.rotation(new Vector3d(x, y, z));
    }

    public ModelText rotation(double rotationY) {
        return this.rotation(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelText background(@NotNull Color color) {
        this.main.backgroundColor(color);
        return this;
    }

    public ModelText text(@NotNull String text) {
        this.main.text(text);
        return this;
    }

    public ModelText text(@NotNull Component text) {
        this.main.text(text);
        return this;
    }

    public ModelText alignment(@NotNull TextDisplay.TextAlignment alignment) {
        this.main.alignment(alignment);
        return this;
    }

    public ModelText brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelText glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        return new TransformationMatrixBuilder().lookAlong(this.facing).translate(this.location).rotate(this.rotation).scale(new Vector3f((Vector3fc)this.size)).buildForBlockDisplay();
    }

    public TextDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public TextDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public TextDisplayBuilder getMain() {
        return this.main;
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getFacing() {
        return this.facing;
    }

    public Vector3f getSize() {
        return this.size;
    }

    public Vector3d getRotation() {
        return this.rotation;
    }
}

