/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.slimefun;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.metamechanists.metacoin.core.ItemStacks;
import org.metamechanists.metacoin.core.Statistics;
import org.metamechanists.metacoin.implementation.slimefun.MetaCoinItem;
import org.metamechanists.metacoin.utils.Keys;
import org.metamechanists.metacoin.utils.Language;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Upgrades {
    SPEED(64),
    PRODUCTION(192){

        @Override
        public long getCost(int currentLevel) {
            if (currentLevel < 65) {
                return (long)Math.ceil(Math.pow(2.0, 0.2 * (double)currentLevel) - 1.0 / (double)currentLevel);
            }
            if (currentLevel < 129) {
                return (long)Math.ceil(Math.pow(64.0, 1.0 + 1.5 * (double)currentLevel / 64.0));
            }
            return (long)Math.ceil(Math.pow(4096.0, (double)currentLevel / 64.0));
        }
    }
    ,
    RELIABILITY(256);

    private final int maxLevel;

    private Upgrades(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public ItemStack getDisplay(Location miner) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ItemStacks.speedUpgrade(this.getCost(miner), this.getLevel(miner), this.getMaxLevel());
            case 1 -> ItemStacks.productionUpgrade(this.getCost(miner), this.getLevel(miner), this.getMaxLevel());
            case 2 -> ItemStacks.reliabilityUpgrade(this.getCost(miner), this.getLevel(miner), this.getMaxLevel());
        };
    }

    public ChestMenu.MenuClickHandler getClickHandler(ChestMenu menu, Location miner) {
        return (player, i, o2, o3) -> {
            int level = this.getLevel(miner);
            if (level >= this.getMaxLevel()) {
                Language.sendMessage(player, "miner.upgrade.max-level", new Object[0]);
                return false;
            }
            long cost = this.getCost(miner);
            long playerValue = MetaCoinItem.getTotalCoinValue(player);
            if (playerValue < cost) {
                Language.sendFormatted(player, "miner.upgrade.too-expensive", playerValue, cost);
                return false;
            }
            long removableValue = MetaCoinItem.getRemovableCoinValue(player, cost);
            if (removableValue < cost) {
                Language.sendFormatted(player, "miner.upgrade.cant-remove", removableValue, cost);
                return false;
            }
            MetaCoinItem.removeCoins(player, cost);
            this.setLevel(miner, level + 1);
            menu.replaceExistingItem(i, this.getDisplay(miner));
            Statistics.updateUpgrades(player, Upgrades.getLevels(miner));
            return false;
        };
    }

    public long getCost(Location miner) {
        return this.getCost(this.getLevel(miner));
    }

    public long getCost(int currentLevel) {
        return currentLevel;
    }

    public int getLevel(Location miner) {
        try {
            return Integer.parseInt(BlockStorage.getLocationInfo((Location)miner, (String)this.name()));
        }
        catch (Exception ignored) {
            BlockStorage.addBlockInfo((Location)miner, (String)this.name(), (String)"1");
            return 1;
        }
    }

    public void setLevel(Location miner, int level) {
        BlockStorage.addBlockInfo((Location)miner, (String)this.name(), (String)String.valueOf(level));
    }

    public static void setLevels(Location miner, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        BlockStorage.addBlockInfo((Location)miner, (String)"SPEED", (String)String.valueOf(PersistentDataAPI.getInt((PersistentDataHolder)itemMeta, Keys.speedLevel)));
        BlockStorage.addBlockInfo((Location)miner, (String)"PRODUCTION", (String)String.valueOf(PersistentDataAPI.getInt((PersistentDataHolder)itemMeta, Keys.productionLevel)));
        BlockStorage.addBlockInfo((Location)miner, (String)"RELIABILITY", (String)String.valueOf(PersistentDataAPI.getInt((PersistentDataHolder)itemMeta, Keys.reliabilityLevel)));
    }

    public static int[] getLevels(Location miner) {
        return new int[]{SPEED.getLevel(miner), PRODUCTION.getLevel(miner), RELIABILITY.getLevel(miner)};
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }
}

