/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.transformations.components;

import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.metamechanists.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.displaymodellib.transformations.components.TransformationMatrixComponent;

public class LookAlong
implements TransformationMatrixComponent {
    private final Vector3f direction;

    public LookAlong(@NotNull Vector3f direction) {
        this.direction = direction;
    }

    public LookAlong(@NotNull Vector3f from, @NotNull Vector3f to) {
        this.direction = TransformationUtils.getDirection(from, to);
    }

    public LookAlong(@NotNull Location from, @NotNull Location to) {
        this.direction = TransformationUtils.getDirection(from, to);
    }

    private float getAngleX() {
        return (float)(-Math.atan2(this.direction.y, Math.sqrt(this.direction.x * this.direction.x + this.direction.z * this.direction.z)));
    }

    private float getAngleY() {
        return (float)Math.atan2(this.direction.x, this.direction.z);
    }

    @Override
    public void apply(@NotNull Matrix4f matrix) {
        matrix.mul((Matrix4fc)new Matrix4f().rotateY(this.getAngleY()).rotateX(this.getAngleX()));
    }
}

