/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.displaymodellib.builders.BlockDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelCuboid
implements ModelComponent {
    private final BlockDisplayBuilder main = new BlockDisplayBuilder();
    private Vector3f location = new Vector3f();
    private Vector3f facing = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f size = new Vector3f();
    private Vector3d rotation = new Vector3d();

    public ModelCuboid location(@NotNull Vector3f location) {
        this.location = location;
        return this;
    }

    public ModelCuboid location(float x, float y, float z) {
        return this.location(new Vector3f(x, y, z));
    }

    public ModelCuboid facing(@NotNull Vector3f facing) {
        this.facing = facing;
        return this;
    }

    public ModelCuboid facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelCuboid size(@NotNull Vector3f size) {
        this.size = size;
        return this;
    }

    public ModelCuboid size(float x, float y, float z) {
        return this.size(new Vector3f(x, y, z));
    }

    public ModelCuboid size(float size) {
        return this.size(new Vector3f(size));
    }

    public ModelCuboid rotation(@NotNull Vector3d rotation) {
        this.rotation = rotation;
        return this;
    }

    public ModelCuboid rotation(double x, double y, double z) {
        return this.rotation(new Vector3d(x, y, z));
    }

    public ModelCuboid rotation(double rotationY) {
        return this.rotation(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelCuboid material(@NotNull Material material) {
        this.main.material(material);
        return this;
    }

    public ModelCuboid block(@NotNull BlockData block) {
        this.main.blockData(block);
        return this;
    }

    public ModelCuboid brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelCuboid glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        return new TransformationMatrixBuilder().lookAlong(this.facing).translate(this.location).rotate(this.rotation).scale(new Vector3f((Vector3fc)this.size)).buildForBlockDisplay();
    }

    public BlockDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public BlockDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public BlockDisplayBuilder getMain() {
        return this.main;
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getFacing() {
        return this.facing;
    }

    public Vector3f getSize() {
        return this.size;
    }

    public Vector3d getRotation() {
        return this.rotation;
    }
}

