/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.slimefun;

import dev.sefiraat.sefilib.entity.display.DisplayGroup;
import dev.sefiraat.sefilib.entity.display.DisplayInteractable;
import io.github.bakedlibs.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.metamechanists.displaymodellib.models.ModelBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;

public abstract class DisplayModelBlock
extends SlimefunItem
implements DisplayInteractable {
    protected DisplayModelBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        this.addItemHandler(new ItemHandler[]{this.blockPlaceHandler(), this.blockBreakHandler(), this.blockUseHandler()});
    }

    protected DisplayModelBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, new CustomItemStack((ItemStack)item, 1));
    }

    public abstract Vector getBuildOffset();

    public abstract Material getBaseMaterial();

    public abstract ModelBuilder getDisplayModel();

    public ModelBuilder getDisplayModel(ItemStack itemStack) {
        return this.getDisplayModel();
    }

    protected void onBlockPlace(@Nonnull BlockPlaceEvent event) {
        Block block = event.getBlock();
        block.setType(this.getBaseMaterial());
        DisplayGroup displayGroup = this.buildDisplayModel(event.getPlayer(), event.getItemInHand(), block);
        BlockStorage.addBlockInfo((Block)block, (String)"display-uuid", (String)displayGroup.getParentUUID().toString());
    }

    @ParametersAreNonnullByDefault
    protected void onBlockBreak(BlockBreakEvent event, ItemStack itemStack, List<ItemStack> drops) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        DisplayGroup displayGroup = this.getDisplayGroup(location);
        if (displayGroup == null) {
            return;
        }
        displayGroup.remove();
    }

    protected void onBlockUse(@Nonnull PlayerRightClickEvent event) {
    }

    protected DisplayGroup buildDisplayModel(Player player, ItemStack itemStack, Block block) {
        DisplayGroup group = new DisplayGroup(block.getLocation().toCenterLocation());
        group.getParentDisplay().setInteractionHeight(0.0f);
        group.getParentDisplay().setInteractionWidth(0.0f);
        Location buildLocation = block.getLocation().add(this.getBuildOffset());
        for (Map.Entry<String, ModelComponent> entry : this.getDisplayModel(itemStack).getComponents().entrySet()) {
            group.addDisplay(entry.getKey(), entry.getValue().build(buildLocation));
        }
        return group;
    }

    public BlockPlaceHandler blockPlaceHandler() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                DisplayModelBlock.this.onBlockPlace(event);
            }
        };
    }

    public BlockBreakHandler blockBreakHandler() {
        return new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack itemStack, List<ItemStack> drops) {
                DisplayModelBlock.this.onBlockBreak(event, itemStack, drops);
                if (event.isCancelled()) {
                    return;
                }
                BlockMenuPreset preset = BlockMenuPreset.getPreset((String)DisplayModelBlock.this.getId());
                if (preset == null) {
                    return;
                }
                Block block = event.getBlock();
                Location location = block.getLocation();
                BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                blockMenu.dropItems(location, preset.getSlotsAccessedByItemTransport(ItemTransportFlow.INSERT));
                blockMenu.dropItems(location, preset.getSlotsAccessedByItemTransport(ItemTransportFlow.WITHDRAW));
            }
        };
    }

    public BlockUseHandler blockUseHandler() {
        return this::onBlockUse;
    }

    @Nullable
    public UUID getUUID(@Nonnull Location location) {
        String uuid = BlockStorage.getLocationInfo((Location)location, (String)"display-uuid");
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    @Nullable
    public DisplayGroup getDisplayGroup(@Nonnull Block block) {
        return this.getDisplayGroup(block.getLocation());
    }

    @Nullable
    public DisplayGroup getDisplayGroup(@Nonnull Location location) {
        UUID uuid = this.getUUID(location);
        if (uuid == null) {
            return null;
        }
        return DisplayGroup.fromUUID(uuid);
    }
}

