/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.acf;

import java.math.BigDecimal;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.metacoin.acf.ACFPatterns;
import org.metamechanists.metacoin.acf.apachecommonslang.ApacheCommonsLangUtil;

public final class ACFUtil {
    public static final Random RANDOM = new Random();

    private ACFUtil() {
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String formatNumber(Integer balance) {
        return NumberFormat.getInstance().format(balance);
    }

    public static <T extends Enum> T getEnumFromName(T[] types, String name) {
        return (T)ACFUtil.getEnumFromName(types, (String)name, null);
    }

    public static <T extends Enum> T getEnumFromName(T[] types, String name, T def) {
        for (T type : types) {
            if (!((Enum)type).name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return def;
    }

    public static <T extends Enum> T getEnumFromOrdinal(T[] types, int ordinal) {
        for (T type : types) {
            if (((Enum)type).ordinal() != ordinal) continue;
            return type;
        }
        return null;
    }

    public static String ucfirst(String str) {
        return ApacheCommonsLangUtil.capitalizeFully(str);
    }

    public static Double parseDouble(String var) {
        return ACFUtil.parseDouble(var, null);
    }

    public static Double parseDouble(String var, Double def) {
        if (var == null) {
            return def;
        }
        try {
            return Double.parseDouble(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Float parseFloat(String var) {
        return ACFUtil.parseFloat(var, null);
    }

    public static Float parseFloat(String var, Float def) {
        if (var == null) {
            return def;
        }
        try {
            return Float.valueOf(Float.parseFloat(var));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Long parseLong(String var) {
        return ACFUtil.parseLong(var, null);
    }

    public static Long parseLong(String var, Long def) {
        if (var == null) {
            return def;
        }
        try {
            return Long.parseLong(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Integer parseInt(String var) {
        return ACFUtil.parseInt(var, null);
    }

    public static Integer parseInt(String var, Integer def) {
        if (var == null) {
            return def;
        }
        try {
            return Integer.parseInt(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static boolean randBool() {
        return RANDOM.nextBoolean();
    }

    public static <T> T nullDefault(Object val, Object def) {
        return (T)(val != null ? val : def);
    }

    public static String join(Collection<String> args) {
        return ApacheCommonsLangUtil.join(args, " ");
    }

    public static String join(Collection<String> args, String sep) {
        return ApacheCommonsLangUtil.join(args, sep);
    }

    public static String join(String[] args) {
        return ACFUtil.join(args, 0, ' ');
    }

    public static String join(String[] args, String sep) {
        return ApacheCommonsLangUtil.join((Object[])args, sep);
    }

    public static String join(String[] args, char sep) {
        return ACFUtil.join(args, 0, sep);
    }

    public static String join(String[] args, int index) {
        return ACFUtil.join(args, index, ' ');
    }

    public static String join(String[] args, int index, char sep) {
        return ApacheCommonsLangUtil.join((Object[])args, sep, index, args.length);
    }

    public static String simplifyString(String str) {
        if (str == null) {
            return null;
        }
        return ACFPatterns.NON_ALPHA_NUMERIC.matcher(str.toLowerCase(Locale.ENGLISH)).replaceAll("");
    }

    public static double round(double x, int scale) {
        try {
            return new BigDecimal(Double.toString(x)).setScale(scale, 4).doubleValue();
        }
        catch (NumberFormatException ex) {
            if (Double.isInfinite(x)) {
                return x;
            }
            return Double.NaN;
        }
    }

    public static int roundUp(int num, int multiple) {
        if (multiple == 0) {
            return num;
        }
        int remainder = num % multiple;
        if (remainder == 0) {
            return num;
        }
        return num + multiple - remainder;
    }

    public static String limit(String str, int limit) {
        return str.length() > limit ? str.substring(0, limit) : str;
    }

    public static String replace(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(Matcher.quoteReplacement(repl));
    }

    public static String replacePattern(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(repl);
    }

    public static String replace(String string, String pattern, String repl) {
        return ACFUtil.replace(string, ACFPatterns.getPattern(Pattern.quote(pattern)), repl);
    }

    public static String replacePattern(String string, String pattern, String repl) {
        return ACFUtil.replace(string, ACFPatterns.getPattern(pattern), repl);
    }

    public static String replacePatternMatch(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(repl);
    }

    public static String replacePatternMatch(String string, String pattern, String repl) {
        return ACFUtil.replacePatternMatch(string, ACFPatterns.getPattern(pattern), repl);
    }

    public static String replaceStrings(String string, String ... replacements) {
        if (replacements.length < 2 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid Replacements");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String key = replacements[i];
            String value = replacements[i + 1];
            if (value == null) {
                value = "";
            }
            string = ACFUtil.replace(string, key, value);
        }
        return string;
    }

    public static String replacePatterns(String string, String ... replacements) {
        if (replacements.length < 2 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid Replacements");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String key = replacements[i];
            String value = replacements[i + 1];
            if (value == null) {
                value = "";
            }
            string = ACFUtil.replacePattern(string, key, value);
        }
        return string;
    }

    public static String capitalize(String str, char[] delimiters) {
        return ApacheCommonsLangUtil.capitalize(str, delimiters);
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        return ApacheCommonsLangUtil.isDelimiter(ch, delimiters);
    }

    public static <T> T random(List<T> arr) {
        if (arr == null || arr.isEmpty()) {
            return null;
        }
        return arr.get(RANDOM.nextInt(arr.size()));
    }

    public static <T> T random(T[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        return arr[RANDOM.nextInt(arr.length)];
    }

    @Deprecated
    public static <T extends Enum<?>> T random(Class<? extends T> enm) {
        return (T)ACFUtil.random((Enum[])enm.getEnumConstants());
    }

    public static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return ACFPatterns.NON_PRINTABLE_CHARACTERS.matcher(Normalizer.normalize(s, Normalizer.Form.NFD)).replaceAll("");
    }

    public static int indexOf(String arg, String[] split) {
        for (int i = 0; i < split.length; ++i) {
            if (!(arg == null ? split[i] == null : arg.equals(split[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String capitalizeFirst(String name) {
        return ACFUtil.capitalizeFirst(name, '_');
    }

    public static String capitalizeFirst(String name, char separator) {
        name = name.toLowerCase(Locale.ENGLISH);
        String[] split = name.split(Character.toString(separator));
        StringBuilder total = new StringBuilder(3);
        for (String s : split) {
            total.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(' ');
        }
        return total.toString().trim();
    }

    public static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static List<String> enumNames(Enum<?>[] values) {
        return Stream.of(values).map(Enum::name).collect(Collectors.toList());
    }

    public static List<String> enumNames(Class<? extends Enum<?>> cls) {
        return ACFUtil.enumNames(cls.getEnumConstants());
    }

    public static String combine(String[] args) {
        return ACFUtil.combine(args, 0);
    }

    public static String combine(String[] args, int start) {
        int size = 0;
        for (int i = start; i < args.length; ++i) {
            size += args[i].length();
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = start; i < args.length; ++i) {
            sb.append(args[i]);
        }
        return sb.toString();
    }

    @Nullable
    public static <E extends Enum<E>> E simpleMatch(Class<? extends Enum<?>> list, String item) {
        if (item == null) {
            return null;
        }
        item = ACFUtil.simplifyString(item);
        for (Enum<?> s : list.getEnumConstants()) {
            String simple = ACFUtil.simplifyString(s.name());
            if (!item.equals(simple)) continue;
            return (E)s;
        }
        return null;
    }

    public static boolean isTruthy(String test) {
        switch (test) {
            case "t": 
            case "true": 
            case "on": 
            case "y": 
            case "yes": 
            case "1": {
                return true;
            }
        }
        return false;
    }

    public static Number parseNumber(String num, boolean suffixes) {
        if (ACFPatterns.getPattern("^0x([0-9A-Fa-f]*)$").matcher(num).matches()) {
            return Long.parseLong(num.substring(2), 16);
        }
        if (ACFPatterns.getPattern("^0b([01]*)$").matcher(num).matches()) {
            return Long.parseLong(num.substring(2), 2);
        }
        ApplyModifierToNumber applyModifierToNumber = new ApplyModifierToNumber(num, suffixes).invoke();
        num = applyModifierToNumber.getNum();
        double mod = applyModifierToNumber.getMod();
        return Double.parseDouble(num) * mod;
    }

    public static BigDecimal parseBigNumber(String num, boolean suffixes) {
        ApplyModifierToNumber applyModifierToNumber = new ApplyModifierToNumber(num, suffixes).invoke();
        num = applyModifierToNumber.getNum();
        double mod = applyModifierToNumber.getMod();
        BigDecimal big = new BigDecimal(num);
        return mod == 1.0 ? big : big.multiply(new BigDecimal(mod));
    }

    public static <T> boolean hasIntersection(Collection<T> list1, Collection<T> list2) {
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Collection<T> intersection(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static int rand(int min, int max) {
        return min + RANDOM.nextInt(max - min + 1);
    }

    public static int rand(int min1, int max1, int min2, int max2) {
        return ACFUtil.randBool() ? ACFUtil.rand(min1, max1) : ACFUtil.rand(min2, max2);
    }

    public static double rand(double min, double max) {
        return RANDOM.nextDouble() * (max - min) + min;
    }

    public static boolean isNumber(String str) {
        return ApacheCommonsLangUtil.isNumeric(str);
    }

    public static String intToRoman(int integer) {
        if (integer == 1) {
            return "I";
        }
        if (integer == 2) {
            return "II";
        }
        if (integer == 3) {
            return "III";
        }
        if (integer == 4) {
            return "IV";
        }
        if (integer == 5) {
            return "V";
        }
        if (integer == 6) {
            return "VI";
        }
        if (integer == 7) {
            return "VII";
        }
        if (integer == 8) {
            return "VIII";
        }
        if (integer == 9) {
            return "IX";
        }
        if (integer == 10) {
            return "X";
        }
        return null;
    }

    public static boolean isInteger(String string) {
        return ACFPatterns.INTEGER.matcher(string).matches();
    }

    public static boolean isFloat(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBetween(float num, double min, double max) {
        return (double)num >= min && (double)num <= max;
    }

    public static double precision(double x, int p) {
        double pow = Math.pow(10.0, p);
        return (double)Math.round(x * pow) / pow;
    }

    public static void sneaky(Throwable t) {
        throw (RuntimeException)ACFUtil.superSneaky(t);
    }

    private static <T extends Throwable> T superSneaky(Throwable t) throws T {
        throw t;
    }

    public static <T> List<T> preformOnImmutable(List<T> list, Consumer<List<T>> action) {
        try {
            action.accept(list);
        }
        catch (UnsupportedOperationException ex) {
            list = new ArrayList<T>(list);
            action.accept(list);
        }
        return list;
    }

    public static <T> T getFirstElement(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static class ApplyModifierToNumber {
        private String num;
        private boolean suffixes;
        private double mod;

        public ApplyModifierToNumber(String num, boolean suffixes) {
            this.num = num;
            this.suffixes = suffixes;
        }

        public String getNum() {
            return this.num;
        }

        public double getMod() {
            return this.mod;
        }

        public ApplyModifierToNumber invoke() {
            this.mod = 1.0;
            if (this.suffixes) {
                switch (this.num.charAt(this.num.length() - 1)) {
                    case 'M': 
                    case 'm': {
                        this.mod = 1000000.0;
                        this.num = this.num.substring(0, this.num.length() - 1);
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        this.mod = 1000.0;
                        this.num = this.num.substring(0, this.num.length() - 1);
                    }
                }
            }
            return this;
        }
    }
}

