/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.metamechanists.displaymodellib.builders.TextDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelAdvancedText
implements ModelComponent {
    private final TextDisplayBuilder main = new TextDisplayBuilder();
    private final TransformationMatrixBuilder matrixBuilder = new TransformationMatrixBuilder();

    public ModelAdvancedText translate(@NotNull Vector3f translation) {
        this.matrixBuilder.translate(translation);
        return this;
    }

    public ModelAdvancedText translate(float x, float y, float z) {
        return this.translate(new Vector3f(x, y, z));
    }

    public ModelAdvancedText facing(@NotNull Vector3f facing) {
        this.matrixBuilder.lookAlong(facing);
        return this;
    }

    public ModelAdvancedText facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelAdvancedText scale(@NotNull Vector3f size) {
        this.matrixBuilder.scale(size);
        return this;
    }

    public ModelAdvancedText scale(float x, float y, float z) {
        return this.scale(new Vector3f(x, y, z));
    }

    public ModelAdvancedText scale(float size) {
        return this.scale(new Vector3f(size));
    }

    public ModelAdvancedText rotate(@NotNull Vector3d rotation) {
        this.matrixBuilder.rotate(rotation);
        return this;
    }

    public ModelAdvancedText rotate(double x, double y, double z) {
        return this.rotate(new Vector3d(x, y, z));
    }

    public ModelAdvancedText rotate(double rotationY) {
        return this.rotate(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelAdvancedText rotateBackwards(@NotNull Vector3d rotation) {
        this.matrixBuilder.rotateBackwards(rotation);
        return this;
    }

    public ModelAdvancedText rotateBackwards(double x, double y, double z) {
        return this.rotateBackwards(new Vector3d(x, y, z));
    }

    public ModelAdvancedText rotateBackwards(double rotationY) {
        return this.rotateBackwards(new Vector3d(0.0, rotationY, 0.0));
    }

    public ModelAdvancedText background(@NotNull Color color) {
        this.main.backgroundColor(color);
        return this;
    }

    public ModelAdvancedText text(@NotNull String text) {
        this.main.text(text);
        return this;
    }

    public ModelAdvancedText text(@NotNull Component text) {
        this.main.text(text);
        return this;
    }

    public ModelAdvancedText alignment(@NotNull TextDisplay.TextAlignment alignment) {
        this.main.alignment(alignment);
        return this;
    }

    public ModelAdvancedText brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelAdvancedText glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    @Override
    public Matrix4f getMatrix() {
        return this.matrixBuilder.buildForBlockDisplay();
    }

    public TextDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public TextDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }

    public TextDisplayBuilder getMain() {
        return this.main;
    }

    public TransformationMatrixBuilder getMatrixBuilder() {
        return this.matrixBuilder;
    }
}

