/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.utils;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.metamechanists.metacoin.metalib.utils.RandomUtils;

public class ParticleUtils {
    private static final double[][] sphere = new double[84][];

    private static Vector generateRandomOffset(boolean setRandom) {
        return setRandom ? new Vector(RandomUtils.randomDouble(), RandomUtils.randomDouble(), RandomUtils.randomDouble()) : new Vector();
    }

    public static void randomParticle(Location location, Particle particle, double radius, int count) {
        ParticleUtils.randomParticle(location, particle, radius, radius, radius, count);
    }

    public static void randomParticle(Location location, Particle particle, double xRadius, double yRadius, double zRadius, int count) {
        for (int i = 0; i < count; ++i) {
            ParticleUtils.randomParticle(location, particle, xRadius, yRadius, zRadius);
        }
    }

    public static void randomParticle(Location location, Particle particle, double radius) {
        ParticleUtils.randomParticle(location, particle, radius, radius, radius);
    }

    public static void randomParticle(Location location, Particle particle, double xRadius, double yRadius, double zRadius) {
        double x = ThreadLocalRandom.current().nextDouble(-xRadius, xRadius + 0.1);
        double y = ThreadLocalRandom.current().nextDouble(-yRadius, yRadius + 0.1);
        double z = ThreadLocalRandom.current().nextDouble(-zRadius, zRadius + 0.1);
        location.getWorld().spawnParticle(particle, location.clone().add(x, y, z), 0, 0.0, 0.0, 0.0, 0.0);
    }

    @ParametersAreNonnullByDefault
    public static void outlineBlock(Player player, Block block, double space, Particle particle, @Nullable Particle.DustOptions dustOptions) {
        ParticleUtils.outlineBox(player, block.getX(), block.getY(), block.getZ(), (double)block.getX() + 1.0, (double)block.getY() + 1.0, (double)block.getZ() + 1.0, space, particle, dustOptions);
    }

    @ParametersAreNonnullByDefault
    public static void outlineBox(Player player, BoundingBox box, double space, Particle particle, @Nullable Particle.DustOptions dustOptions) {
        ParticleUtils.outlineBox(player, (int)box.getMinX(), (int)box.getMinY(), (int)box.getMinZ(), (int)box.getMaxX(), (int)box.getMaxY(), (int)box.getMaxZ(), space, particle, dustOptions);
    }

    @ParametersAreNonnullByDefault
    public static void outlineBox(Player player, double lowerX, double lowerY, double lowerZ, double upperX, double upperY, double upperZ, double space, Particle particle, @Nullable Particle.DustOptions dustOptions) {
        Vector bottomBackLeft = new Vector(lowerX, lowerY, lowerZ);
        Vector bottomBackRight = new Vector(lowerX, lowerY, upperZ);
        Vector bottomFrontLeft = new Vector(upperX, lowerY, lowerZ);
        Vector bottomFrontRight = new Vector(upperX, lowerY, upperZ);
        Vector topBackLeft = new Vector(lowerX, upperY, lowerZ);
        Vector topBackRight = new Vector(lowerX, upperY, upperZ);
        Vector topFrontLeft = new Vector(upperX, upperY, lowerZ);
        Vector topFrontRight = new Vector(upperX, upperY, upperZ);
        ParticleUtils.drawLine(player, bottomBackLeft, bottomFrontLeft, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomBackRight, bottomFrontRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomBackLeft, bottomBackRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomFrontLeft, bottomFrontRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomBackLeft, topBackLeft, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomFrontLeft, topFrontLeft, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomBackRight, topBackRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, bottomFrontRight, topFrontRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, topBackLeft, topFrontLeft, space, particle, dustOptions);
        ParticleUtils.drawLine(player, topBackRight, topFrontRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, topBackLeft, topBackRight, space, particle, dustOptions);
        ParticleUtils.drawLine(player, topFrontLeft, topFrontRight, space, particle, dustOptions);
    }

    @Deprecated(forRemoval=true)
    @ParametersAreNonnullByDefault
    public static void drawLine(Player player, Particle particle, Location start, Location end, double space, @Nullable Particle.DustOptions dustOptions) {
        ParticleUtils.drawLine(player, start.toVector(), end.toVector(), space, particle, dustOptions);
    }

    @ParametersAreNonnullByDefault
    public static void drawLine(Player player, Location start, Location end, double space, Particle particle, @Nullable Particle.DustOptions dustOptions) {
        ParticleUtils.drawLine(player, start.toVector(), end.toVector(), space, particle, dustOptions);
    }

    @ParametersAreNonnullByDefault
    public static void drawLine(Player player, Vector start, Vector end, double space, Particle particle, @Nullable Particle.DustOptions dustOptions) {
        double distance = start.distance(end);
        Vector step = end.clone().subtract(start).normalize().multiply(space);
        start = start.clone();
        for (double currentPoint = 0.0; currentPoint < distance; currentPoint += space) {
            if (dustOptions != null) {
                player.spawnParticle(particle, start.getX(), start.getY(), start.getZ(), 1, (Object)dustOptions);
            } else {
                player.spawnParticle(particle, start.getX(), start.getY(), start.getZ(), 1);
            }
            start.add(step);
        }
    }

    @Deprecated(forRemoval=true)
    public static void highlightBlock(Player player, Block block, Particle particle, Particle.DustOptions dustOptions) {
        ParticleUtils.highlightBlockCorners(player, block, particle, dustOptions);
    }

    public static void highlightBlockCorners(Player player, Block block, Particle particle, Particle.DustOptions dustOptions) {
        ParticleUtils.drawSquareCorners(player, block.getLocation(), 1, particle, dustOptions);
        ParticleUtils.drawSquareCorners(player, block.getLocation().add(0.0, 1.0, 0.0), 1, particle, dustOptions);
    }

    public static void drawSquareCorners(Player player, Location corner, int length, Particle particle, Particle.DustOptions dustOptions) {
        player.spawnParticle(particle, corner.getX(), corner.getY(), corner.getZ(), 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX() + (double)length, corner.getY(), corner.getZ(), 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX() + (double)length, corner.getY(), corner.getZ() + (double)length, 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX(), corner.getY(), corner.getZ() + (double)length, 1, (Object)dustOptions);
    }

    public static void sphereIn(Location location, Particle particle) {
        ParticleUtils.sphereIn(location, particle, 1.0, false);
    }

    public static void sphereIn(Location location, Particle particle, double speed) {
        ParticleUtils.sphereIn(location, particle, speed, false);
    }

    public static void sphereIn(Location location, Particle particle, boolean randomOffset) {
        ParticleUtils.sphereIn(location, particle, 1.0, randomOffset);
    }

    public static void sphereIn(Location location, Particle particle, double speed, boolean randomOffset) {
        World world = location.getWorld();
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]).add(ParticleUtils.generateRandomOffset(randomOffset));
            Vector direction = location.clone().subtract(particleLocation.clone()).toVector();
            world.spawnParticle(particle, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
        }
    }

    public static void spheresUp(Location location, Particle particle) {
        World world = location.getWorld();
        double[] speeds = new double[]{0.1, 0.15, 0.2, 0.25};
        for (double[] offsets : sphere) {
            world.spawnParticle(particle, location.clone().add(offsets[0], offsets[1], offsets[2]), 0, 0.0, 5.0, 0.0, speeds[new Random().nextInt(0, speeds.length)]);
        }
    }

    public static void sphereOut(Location location, Particle particle) {
        ParticleUtils.sphereOut(location, particle, 0.25, false);
    }

    public static void sphereOut(Location location, Particle particle, double speed) {
        ParticleUtils.sphereOut(location, particle, speed, false);
    }

    public static void sphereOut(Location location, Particle particle, boolean randomOffset) {
        ParticleUtils.sphereOut(location, particle, 0.25, randomOffset);
    }

    public static void sphereOut(Location location, Particle particle, double speed, boolean randomOffset) {
        World world = location.getWorld();
        location = location.clone().add(0.0, 0.5, 0.0);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]).add(ParticleUtils.generateRandomOffset(randomOffset));
            Vector direction = particleLocation.clone().subtract(location.clone()).toVector();
            world.spawnParticle(particle, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
        }
    }

    public static void sphere(Location location, Particle particle, double scale, boolean randomOffset) {
        World world = location.getWorld();
        location = location.clone().add(0.0, 0.5, 0.0);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0] * scale, offsets[1] * scale, offsets[2] * scale).add(ParticleUtils.generateRandomOffset(randomOffset));
            world.spawnParticle(particle, particleLocation, 0, 0.0, 0.0, 0.0);
        }
    }

    public static double[][] getSphere() {
        return sphere;
    }

    static {
        int sphereLoc = 0;
        for (double i = 0.0; i <= Math.PI; i += 0.5235987755982988) {
            double radius = Math.sin(i);
            double y = Math.cos(i);
            for (double a = 0.0; a < Math.PI * 2; a += 0.5235987755982988) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                ParticleUtils.sphere[sphereLoc] = new double[]{x, y, z};
                ++sphereLoc;
            }
        }
    }
}

