/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.dough.versions;

import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.metamechanists.metacoin.metalib.dough.common.CommonPatterns;
import org.metamechanists.metacoin.metalib.dough.versions.SemanticVersion;
import org.metamechanists.metacoin.metalib.dough.versions.UnknownServerVersionException;

public class MinecraftVersion
extends SemanticVersion {
    public MinecraftVersion(int major, int minor, int patch) {
        super(major, minor, patch);
    }

    private MinecraftVersion(@Nonnull SemanticVersion version) {
        this(version.getMajorVersion(), version.getMinorVersion(), version.getPatchVersion());
    }

    @Nonnull
    public static MinecraftVersion of(@Nonnull Server server) throws UnknownServerVersionException {
        Validate.notNull((Object)server, (String)"Server should not be null!");
        String bukkitVersion = server.getBukkitVersion();
        try {
            String minecraftVersion = CommonPatterns.DASH.split(bukkitVersion)[0];
            return new MinecraftVersion(SemanticVersion.parse(minecraftVersion));
        }
        catch (Exception x) {
            throw new UnknownServerVersionException(bukkitVersion, x);
        }
    }

    @Nonnull
    public static MinecraftVersion get() throws UnknownServerVersionException {
        return MinecraftVersion.of(Bukkit.getServer());
    }

    public static boolean isMocked(@Nonnull Server server) {
        for (Class<?> clazz = server.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().endsWith("mockbukkit.ServerMock")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMocked() {
        return MinecraftVersion.isMocked(Bukkit.getServer());
    }

    @Override
    @Nonnull
    public String getAsString() {
        return "Minecraft " + super.getAsString();
    }
}

