/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.sefilib.entity.display;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.metamechanists.metacoin.metalib.sefilib.entity.display.DisplayInteractable;
import org.metamechanists.metacoin.metalib.sefilib.protections.Protections;

public class DisplayGroupManager
implements Listener {
    private static DisplayGroupManager instance;

    public DisplayGroupManager(@Nonnull JavaPlugin plugin) {
        Preconditions.checkArgument((instance == null ? 1 : 0) != 0, (Object)"Cannot create a new instance of the DisplayGroupManager");
        instance = this;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onInteraction(@Nonnull PlayerInteractEntityEvent event) {
        if (event.getRightClicked().getType() == EntityType.INTERACTION) {
            Player player = event.getPlayer();
            Block block = event.getRightClicked().getLocation().getBlock();
            SlimefunItem item = BlockStorage.check((Block)block);
            if (item instanceof DisplayInteractable && Protections.hasPermission(player, block, Interaction.INTERACT_BLOCK)) {
                EquipmentSlot slot = event.getHand();
                PlayerInteractEvent interactEvent = new PlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, player.getInventory().getItem(slot), block, BlockFace.UP);
                Bukkit.getPluginManager().callEvent((Event)interactEvent);
                if (slot == EquipmentSlot.HAND) {
                    player.swingMainHand();
                } else {
                    player.swingOffHand();
                }
            }
        }
    }

    @EventHandler
    public void onAttack(@Nonnull EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Block block;
            SlimefunItem slimefunItem;
            Player player = (Player)entity;
            if (event.getEntity().getType() == EntityType.INTERACTION && (slimefunItem = BlockStorage.check((Block)(block = event.getEntity().getLocation().getBlock()))) instanceof DisplayInteractable && Protections.hasPermission(player, block, Interaction.BREAK_BLOCK)) {
                BlockBreakEvent breakEvent = new BlockBreakEvent(block, player);
                Bukkit.getPluginManager().callEvent((Event)breakEvent);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPlace(@Nonnull BlockPlaceEvent event) {
        SlimefunItem slimefunItem = BlockStorage.check((Block)event.getBlock());
        if (slimefunItem instanceof DisplayInteractable) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(@Nonnull BlockBreakEvent event) {
        Block above = event.getBlock().getRelative(BlockFace.UP);
        SlimefunItem slimefunItem = BlockStorage.check((Block)above);
        if (slimefunItem instanceof DisplayInteractable) {
            BlockBreakEvent breakEvent = new BlockBreakEvent(above, event.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (!breakEvent.isCancelled()) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

