/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.dough.scheduling;

import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.metamechanists.metacoin.metalib.dough.scheduling.TaskNode;

public class TaskQueue {
    private TaskNode head;

    public void execute(@Nonnull Plugin plugin) {
        if (this.head == null) {
            throw new IllegalStateException("Cannot execute TaskQueue, no head was found");
        }
        this.run(plugin, this.head, 0);
    }

    private void run(@Nonnull Plugin plugin, @Nullable TaskNode node, int index) {
        if (node == null) {
            return;
        }
        Runnable runnable = () -> {
            node.execute(index);
            this.run(plugin, node.getNextNode(), index + 1);
        };
        if (node.isAsynchronous()) {
            if (node.getDelay() > 0) {
                Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, runnable, (long)node.getDelay());
            } else {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable);
            }
        } else if (node.getDelay() > 0) {
            Bukkit.getScheduler().runTaskLater(plugin, runnable, (long)node.getDelay());
        } else {
            Bukkit.getScheduler().runTask(plugin, runnable);
        }
    }

    @Nonnull
    public TaskQueue thenRun(@Nonnull IntConsumer consumer) {
        return this.append(new TaskNode(consumer, false));
    }

    @Nonnull
    public TaskQueue thenRun(@Nonnull Runnable runnable) {
        return this.thenRun((int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRunAsynchronously(@Nonnull IntConsumer consumer) {
        return this.append(new TaskNode(consumer, true));
    }

    @Nonnull
    public TaskQueue thenRunAsynchronously(@Nonnull Runnable runnable) {
        return this.thenRunAsynchronously((int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRun(int ticks, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenAfter() must be given a time that is greater than zero!");
        }
        return this.append(new TaskNode(consumer, ticks, false));
    }

    @Nonnull
    public TaskQueue thenRun(int ticks, @Nonnull Runnable runnable) {
        return this.thenRun(ticks, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRunAsynchronously(int ticks, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenAfter() must be given a time that is greater than zero!");
        }
        return this.append(new TaskNode(consumer, ticks, true));
    }

    @Nonnull
    public TaskQueue thenRunAsynchronously(int ticks, @Nonnull Runnable runnable) {
        return this.thenRunAsynchronously(ticks, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRepeat(int iterations, @Nonnull IntConsumer consumer) {
        for (int i = 0; i < iterations; ++i) {
            this.append(new TaskNode(consumer, false));
        }
        return this;
    }

    @Nonnull
    public TaskQueue thenRepeat(int iterations, @Nonnull Runnable runnable) {
        return this.thenRepeat(iterations, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRepeatAsynchronously(int iterations, @Nonnull IntConsumer consumer) {
        for (int i = 0; i < iterations; ++i) {
            this.append(new TaskNode(consumer, true));
        }
        return this;
    }

    @Nonnull
    public TaskQueue thenRepeatAsynchronously(int iterations, @Nonnull Runnable runnable) {
        return this.thenRepeatAsynchronously(iterations, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRepeatEvery(int ticks, int iterations, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenRepeatEvery() must be given a time that is greater than zero!");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new TaskNode(consumer, ticks, false));
        }
        return this;
    }

    @Nonnull
    public TaskQueue thenRepeatEvery(int ticks, int iterations, @Nonnull Runnable runnable) {
        return this.thenRepeatEvery(ticks, iterations, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenRepeatEveryAsynchronously(int ticks, int iterations, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenRepeatEveryAsynchronously() must be given a time that is greater than zero!");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new TaskNode(consumer, ticks, true));
        }
        return this;
    }

    @Nonnull
    public TaskQueue thenRepeatEveryAsynchronously(int ticks, int iterations, @Nonnull Runnable runnable) {
        return this.thenRepeatEveryAsynchronously(ticks, iterations, (int i) -> runnable.run());
    }

    public void thenLoop(@Nonnull IntConsumer consumer) {
        TaskNode node = new TaskNode(consumer, false);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoop(@Nonnull Runnable runnable) {
        this.thenLoop((int i) -> runnable.run());
    }

    public void thenLoopAsynchronously(@Nonnull IntConsumer consumer) {
        TaskNode node = new TaskNode(consumer, true);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopAsynchronously(@Nonnull Runnable runnable) {
        this.thenLoopAsynchronously((int i) -> runnable.run());
    }

    public void thenLoopEvery(int ticks, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenLoopEvery() must be given a time that is greater than zero!");
        }
        TaskNode node = new TaskNode(consumer, ticks, false);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopEvery(int ticks, @Nonnull Runnable runnable) {
        this.thenLoopEvery(ticks, (int i) -> runnable.run());
    }

    public void thenLoopEveryAsynchronously(int ticks, @Nonnull IntConsumer consumer) {
        if (ticks < 1) {
            throw new IllegalArgumentException("thenLoopEveryAsynchronously() must be given a time that is greater than zero!");
        }
        TaskNode node = new TaskNode(consumer, ticks, true);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopEveryAsynchronously(int ticks, @Nonnull Runnable runnable) {
        this.thenLoopEveryAsynchronously(ticks, (int i) -> runnable.run());
    }

    @Nonnull
    public TaskQueue thenWait(int ticks) {
        TaskNode node = new TaskNode(i -> {}, false);
        node.setDelay(ticks);
        return this.append(node);
    }

    @Nonnull
    private TaskQueue append(@Nonnull TaskNode node) {
        if (this.head == null) {
            this.head = node;
        } else {
            TaskNode current = this.head;
            while (current.hasNextNode()) {
                if (current == current.getNextNode()) {
                    throw new IllegalAccessError("You cannot append to a TaskQueue that contains a loop");
                }
                current = current.getNextNode();
            }
            current.setNextNode(node);
        }
        return this;
    }
}

