/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.implementation.runnables;

import dev.sefiraat.sefilib.entity.display.DisplayGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.metacoin.MetaCoin;
import org.metamechanists.metacoin.core.ItemStacks;
import org.metamechanists.metacoin.core.Statistics;
import org.metamechanists.metacoin.implementation.slimefun.Upgrades;
import org.metamechanists.metacoin.metalib.utils.ItemUtils;
import org.metamechanists.metacoin.metalib.utils.ParticleUtils;
import org.metamechanists.metacoin.metalib.utils.RandomUtils;

public class WarrantyVoidRunnable
extends BukkitRunnable {
    private static final List<Sound> ALARM_SOUNDS = List.of(Sound.BLOCK_NOTE_BLOCK_BANJO, Sound.BLOCK_NOTE_BLOCK_BASS, Sound.BLOCK_NOTE_BLOCK_BELL, Sound.BLOCK_NOTE_BLOCK_BIT, Sound.BLOCK_NOTE_BLOCK_CHIME, Sound.BLOCK_NOTE_BLOCK_FLUTE, Sound.BLOCK_NOTE_BLOCK_GUITAR, Sound.BLOCK_NOTE_BLOCK_HARP, Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE, Sound.BLOCK_NOTE_BLOCK_PLING, Sound.BLOCK_NOTE_BLOCK_SNARE, Sound.BLOCK_NOTE_BLOCK_XYLOPHONE);
    private final Player player;
    private final Block miner;
    private final Location location;
    private final DisplayGroup group;
    private final ItemStack slag;
    private int ticks = 0;

    public WarrantyVoidRunnable(Player player, Block miner, DisplayGroup group) {
        this.player = player;
        this.miner = miner;
        this.location = miner.getLocation().toCenterLocation();
        this.group = group;
        this.slag = ItemStacks.machineSlag(this.player, Upgrades.getLevels(miner.getLocation()));
        BlockStorage.addBlockInfo((Block)miner, (String)"WARRANTY_VOID", (String)"TRUE");
        this.runTaskTimer((Plugin)MetaCoin.getInstance(), 0L, 1L);
        Statistics.addVoidedWarranty(player);
    }

    public void run() {
        Display display;
        ThreadLocalRandom random = RandomUtils.randomThread;
        Map<String, Display> displays = this.group.getDisplays();
        if (this.ticks % 2 == 0) {
            ArrayList<Display> displayList = new ArrayList<Display>(displays.values());
            for (int i = 0; i < displayList.size(); ++i) {
                BlockDisplay blockDisplay;
                display = RandomUtils.randomChoice(displayList);
                if (display instanceof BlockDisplay && (blockDisplay = (BlockDisplay)display).getBlock().getMaterial() == Material.FIRE) continue;
                this.group.addDisplay("fire_" + this.ticks, (Display)new ModelCuboid().material(Material.FIRE).brightness(15).size(0.01f).location(display.getTransformation().getTranslation().add((float)(0.1 * Math.pow(-1.0, this.ticks)), (float)(0.1 * Math.pow(-1.0, this.ticks + 1)), (float)(0.1 * Math.pow(-1.0, this.ticks)))).build(display.getLocation()));
                break;
            }
        }
        for (String name : displays.keySet()) {
            Transformation transformation;
            if (!name.contains("fire") || name.contains(String.valueOf(this.ticks)) || !((transformation = (display = displays.get(name)).getTransformation()).getScale().x() <= 0.011f)) continue;
            display.setInterpolationDelay(-1);
            display.setInterpolationDuration(4);
            display.setTransformation(new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), new Vector3f(random.nextFloat(0.4f, 0.8f)), transformation.getRightRotation()));
        }
        if (this.ticks < 100) {
            ParticleUtils.randomParticle(this.location, Particle.CAMPFIRE_SIGNAL_SMOKE, 0.5, RandomUtils.randomInteger(4, 10));
            ParticleUtils.randomParticle(this.location, Particle.LAVA, 0.5, RandomUtils.randomInteger(5, 20));
            this.miner.getWorld().playSound(this.location, Sound.BLOCK_LAVA_EXTINGUISH, 0.5f, random.nextFloat(0.1f, 1.0f));
            this.miner.getWorld().playSound(this.location, Sound.BLOCK_LAVA_POP, 0.5f, random.nextFloat(0.1f, 1.0f));
            this.miner.getWorld().playSound(this.location, RandomUtils.randomChoice(ALARM_SOUNDS), 1.0f, 1.0f);
            ++this.ticks;
            return;
        }
        this.cancel();
        this.miner.setType(Material.AIR);
        this.miner.getWorld().createExplosion(this.location, 32.0f, true, true);
        for (Display display2 : displays.values()) {
            Transformation transformation = display2.getTransformation();
            display2.setInterpolationDelay(-1);
            display2.setInterpolationDuration(15);
            display2.setTransformation(new Transformation(transformation.getTranslation().mul((Vector3fc)new Vector3f((float)RandomUtils.randomInteger(-4, 4), (float)RandomUtils.randomInteger(-4, 4), (float)RandomUtils.randomInteger(-4, 4))), transformation.getLeftRotation(), new Vector3f(), transformation.getRightRotation()));
        }
        BlockStorage.clearBlockInfo((Block)this.miner);
        Bukkit.getScheduler().runTaskLater((Plugin)MetaCoin.getInstance(), () -> {
            this.group.remove();
            ItemUtils.addOrDropItem(this.player, this.slag);
        }, 30L);
    }

    public static boolean isVoided(Block miner) {
        return BlockStorage.getLocationInfo((Location)miner.getLocation(), (String)"WARRANTY_VOID") != null;
    }
}

