/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.core;

import it.unimi.dsi.fastutil.longs.LongComparators;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.metamechanists.metacoin.MetaCoin;

public class Leaderboard {
    private static final List<Long> LEADERBOARD = new ArrayList<Long>();
    private static final Map<UUID, Long> VALUES = new HashMap<UUID, Long>();

    public static String getPosition(UUID uuid) {
        if (!VALUES.containsKey(uuid)) {
            VALUES.put(uuid, 0L);
            if (!LEADERBOARD.contains(0L)) {
                LEADERBOARD.add(0L);
                LEADERBOARD.sort((Comparator<Long>)LongComparators.OPPOSITE_COMPARATOR);
            }
        }
        return String.valueOf(LEADERBOARD.indexOf(VALUES.get(uuid)) + 1);
    }

    public static String getValueAt(int position) {
        return LEADERBOARD.size() < position ? "" : "%,d".formatted(LEADERBOARD.get(position - 1));
    }

    public static String getPlayersAt(int position) {
        if (LEADERBOARD.size() < position) {
            return "";
        }
        long value = LEADERBOARD.get(position - 1);
        StringBuilder players = new StringBuilder();
        for (Map.Entry<UUID, Long> entry : VALUES.entrySet()) {
            if (entry.getValue() != value) continue;
            if (!players.isEmpty()) {
                players.append(", ");
            }
            players.append(Bukkit.getOfflinePlayer((UUID)entry.getKey()).getName());
        }
        return players.toString();
    }

    public static long getValue(UUID uuid) {
        return VALUES.getOrDefault(uuid, 0L);
    }

    public static void updateLeaderboard(UUID uuid, long value) {
        long oldValue = VALUES.getOrDefault(uuid, 0L);
        VALUES.put(uuid, value);
        if (!VALUES.containsValue(oldValue)) {
            LEADERBOARD.remove(oldValue);
        }
        if (!LEADERBOARD.contains(value)) {
            LEADERBOARD.add(value);
            LEADERBOARD.sort((Comparator<Long>)LongComparators.OPPOSITE_COMPARATOR);
        }
        Leaderboard.save();
    }

    public static void reset() {
        LEADERBOARD.clear();
        VALUES.clear();
    }

    public static void init() {
        MetaCoin instance = MetaCoin.getInstance();
        Logger logger = instance.getLogger();
        File leaderboardFile = new File(instance.getDataFolder(), "leaderboard.yml");
        if (!leaderboardFile.exists()) {
            try {
                leaderboardFile.createNewFile();
            }
            catch (Exception e) {
                logger.severe("Could not create the leaderboard.yml file!");
                logger.severe(e.getLocalizedMessage());
                return;
            }
        }
        YamlConfiguration leaderboard = YamlConfiguration.loadConfiguration((File)leaderboardFile);
        for (String uuidString : leaderboard.getKeys(false)) {
            long value = leaderboard.getLong(uuidString, 0L);
            if (value <= 0L) continue;
            try {
                VALUES.put(UUID.fromString(uuidString), value);
                if (LEADERBOARD.contains(value)) continue;
                LEADERBOARD.add(value);
            }
            catch (Exception e) {
                logger.severe("Could not load %s's coin value of %,d!".formatted(uuidString, value));
                logger.severe(e.getLocalizedMessage());
            }
        }
        LEADERBOARD.sort((Comparator<Long>)LongComparators.OPPOSITE_COMPARATOR);
    }

    public static void save() {
        YamlConfiguration leaderboard = new YamlConfiguration();
        for (UUID uuid : VALUES.keySet()) {
            leaderboard.set(uuid.toString(), (Object)VALUES.get(uuid));
        }
        MetaCoin instance = MetaCoin.getInstance();
        Logger logger = instance.getLogger();
        File leaderboardFile = new File(instance.getDataFolder(), "leaderboard.yml");
        try {
            leaderboard.save(leaderboardFile);
        }
        catch (Exception e) {
            logger.severe("Could not save leaderboard.yml!");
            logger.severe(e.getLocalizedMessage());
        }
    }
}

