/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.metamechanists.metacoin.metalib.dough.items.CustomItemStack;
import org.metamechanists.metacoin.metalib.utils.ChatUtils;

public class ItemUtils {
    private static final NamespacedKey cooldownKey = new NamespacedKey("metalib", "cooldown");

    public static ItemStack makeEnchanted(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_DESTROYS});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack orAir(ItemStack itemStack) {
        return itemStack == null ? new ItemStack(Material.AIR) : itemStack;
    }

    @ParametersAreNonnullByDefault
    public static void addOrDropItemMainHand(Player player, ItemStack itemStack) {
        if (player.getInventory().getItemInMainHand().getType().isEmpty()) {
            player.getInventory().setItemInMainHand(itemStack);
            return;
        }
        ItemUtils.addOrDropItem(player, itemStack);
    }

    @ParametersAreNonnullByDefault
    public static void addOrDropItem(Player player, ItemStack ... itemStacks) {
        HashMap remaining = player.getInventory().addItem(itemStacks);
        if (remaining.size() > 0) {
            for (ItemStack itemStack : remaining.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), itemStack);
            }
        }
    }

    public static void addItem(Inventory inventory, ItemStack itemStack) {
        ItemStack[] itemStacks = inventory.getStorageContents();
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack inventoryStack = itemStacks[i];
            if (inventoryStack == null || inventoryStack.getType().isAir()) {
                itemStacks[i] = new CustomItemStack(itemStack);
                break;
            }
            if (!io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils.canStack((ItemStack)inventoryStack, (ItemStack)itemStack)) continue;
            int count = Math.min(itemStack.getAmount(), inventoryStack.getMaxStackSize() - inventoryStack.getAmount());
            inventoryStack.setAmount(inventoryStack.getAmount() + count);
            itemStack.setAmount(itemStack.getAmount() - count);
            if (itemStack.getAmount() == 0) break;
        }
        inventory.setStorageContents(itemStacks);
    }

    public static int freeSpace(Inventory inventory, ItemStack itemStack) {
        int freeSpace = 0;
        for (ItemStack inventoryStack : inventory.getStorageContents()) {
            if (inventoryStack == null || inventoryStack.getType().isAir()) {
                freeSpace += itemStack.getMaxStackSize();
                continue;
            }
            if (!org.metamechanists.metacoin.metalib.dough.items.ItemUtils.canStack(inventoryStack, itemStack)) continue;
            freeSpace += inventoryStack.getMaxStackSize() - inventoryStack.getAmount();
        }
        return freeSpace;
    }

    @NonNull
    public static String getItemName(ItemStack itemStack) {
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return ChatColor.WHITE + ChatUtils.humanize(itemStack.getType().name());
    }

    public static String toId(String string) {
        StringBuilder id = new StringBuilder();
        for (char character : ChatColor.stripColor((String)string).replace(" ", "_").toCharArray()) {
            if (!Character.isLetterOrDigit(character)) continue;
            id.append(character);
        }
        return id.toString();
    }

    public static void fillMenuSlots(ChestMenu chestMenu, int[] slots, ItemStack itemStack) {
        for (int slot : slots) {
            chestMenu.addItem(slot, itemStack, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public static boolean onCooldown(ItemStack itemStack) {
        return itemStack.getItemMeta() == null || PersistentDataAPI.getLong((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)cooldownKey, (long)System.currentTimeMillis()) > System.currentTimeMillis();
    }

    public static long getCooldown(ItemStack itemStack) {
        return itemStack.getItemMeta() == null ? 0L : PersistentDataAPI.getLong((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)cooldownKey, (long)0L);
    }

    public static void startCooldown(ItemStack itemStack, double seconds) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        PersistentDataAPI.setLong((PersistentDataHolder)itemMeta, (NamespacedKey)cooldownKey, (long)(System.currentTimeMillis() + (long)(seconds * 1000.0)));
        itemStack.setItemMeta(itemMeta);
    }

    public static ItemStack itemStackFromId(String id) {
        Material material = Material.getMaterial((String)id.toUpperCase());
        SlimefunItem slimefunItem = SlimefunItem.getById((String)id.toUpperCase());
        if (material != null) {
            return new ItemStack(material);
        }
        if (slimefunItem != null) {
            return slimefunItem.getItem();
        }
        return null;
    }
}

