/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin.metalib.sefilib.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class BukkitObjectDataType<T extends ConfigurationSerializable>
implements PersistentDataType<byte[], T> {
    @Nonnull
    private final Class<T> clazz;

    public BukkitObjectDataType(@Nonnull Class<T> clazz) {
        this.clazz = clazz;
    }

    @Nonnull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @Nonnull
    public Class<T> getComplexType() {
        return this.clazz;
    }

    @Nonnull
    public byte[] toPrimitive(@Nonnull T bukkitObject, @Nonnull PersistentDataAdapterContext context) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitStream = new BukkitObjectOutputStream((OutputStream)stream);
            bukkitStream.writeObject(bukkitObject);
            return stream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public T fromPrimitive(byte[] byteArray, PersistentDataAdapterContext context) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(byteArray);
            BukkitObjectInputStream bukkitStream = new BukkitObjectInputStream((InputStream)stream);
            Object read = bukkitStream.readObject();
            return (T)((ConfigurationSerializable)read);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

