/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metacoin;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.metamechanists.metacoin.acf.PaperCommandManager;
import org.metamechanists.metacoin.bstats.bukkit.Metrics;
import org.metamechanists.metacoin.bstats.charts.SimplePie;
import org.metamechanists.metacoin.bstats.charts.SingleLineChart;
import org.metamechanists.metacoin.core.Groups;
import org.metamechanists.metacoin.core.Items;
import org.metamechanists.metacoin.core.Leaderboard;
import org.metamechanists.metacoin.core.Statistics;
import org.metamechanists.metacoin.implementation.commands.MetaCoinCommand;
import org.metamechanists.metacoin.implementation.commands.flags.FunnyFlags;
import org.metamechanists.metacoin.implementation.compat.PapiIntegration;
import org.metamechanists.metacoin.implementation.listeners.MinerListeners;
import org.metamechanists.metacoin.implementation.listeners.ProjectileListener;
import org.metamechanists.metacoin.utils.Language;

public final class MetaCoin
extends JavaPlugin
implements SlimefunAddon {
    private static MetaCoin instance;

    public void onEnable() {
        instance = this;
        Statistics.init();
        Leaderboard.init();
        Language.init();
        Groups.init();
        Items.init();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PapiIntegration();
        }
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("auto-update") && this.getDescription().getVersion().startsWith("DEV")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "MetaCoin").start();
        }
        Metrics metrics = new Metrics(this, 25310);
        metrics.addCustomChart(new SingleLineChart("global_mined_metacoins", () -> (int)Math.min(Integer.MAX_VALUE, Statistics.getMinedMetaCoins())));
        metrics.addCustomChart(new SingleLineChart("global_unsafe_mined_metacoins", () -> (int)Statistics.getMinedMetaCoins()));
        metrics.addCustomChart(new SingleLineChart("global_mined_metacoins_millions", () -> (int)Math.min(Integer.MAX_VALUE, Statistics.getMinedMetaCoins() / 1000000L)));
        metrics.addCustomChart(new SingleLineChart("global_acquired_metaminers", () -> Statistics.getMetaMiners().getKeys(false).size()));
        metrics.addCustomChart(new SingleLineChart("global_voided_warranties", () -> Statistics.getVoidedWarranties().size()));
        metrics.addCustomChart(new SimplePie("top_of_server_leaderboard", () -> Leaderboard.getValueAt(1)));
        this.addUpgradeGraphs(metrics, "speed");
        this.addUpgradeGraphs(metrics, "production");
        this.addUpgradeGraphs(metrics, "reliability");
        this.registerListeners();
        this.registerCommands();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, Statistics::save, 1200L, 12000L);
    }

    private void addUpgradeGraphs(Metrics metrics, String upgrade) {
        metrics.addCustomChart(new SimplePie("highest_" + upgrade + "_upgrade", () -> Statistics.getAllUpgradeLevels(upgrade).stream().max(Integer::compareTo).orElse(0).toString()));
        metrics.addCustomChart(new SimplePie("average_" + upgrade + "_upgrade", () -> String.valueOf(Statistics.getAllUpgradeLevels(upgrade).stream().mapToInt(Integer::intValue).average().orElse(0.0))));
        metrics.addCustomChart(new SimplePie("median_" + upgrade + "_upgrade", () -> {
            List<Integer> levels = Statistics.getAllUpgradeLevels(upgrade);
            levels.sort(Integer::compareTo);
            int size = levels.size();
            if (size % 2 == 0) {
                return size == 0 ? "0" : String.valueOf(levels.get(size / 2 - 1));
            }
            return String.valueOf(levels.get(size / 2));
        }));
    }

    private void registerListeners() {
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new MinerListeners(), (Plugin)this);
        manager.registerEvents((Listener)new ProjectileListener(), (Plugin)this);
    }

    private void registerCommands() {
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.enableUnstableAPI("help");
        manager.registerCommand(new MetaCoinCommand());
        if (this.getServer().getPluginManager().isPluginEnabled("WorldEditSlimefun")) {
            FunnyFlags.init();
        }
    }

    public void onDisable() {
        Statistics.save();
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public String getBugTrackerURL() {
        return "https://www.youtube.com/watch?v=dQw4w9WgXcQ";
    }

    public static MetaCoin getInstance() {
        return instance;
    }
}

