/*
 * Decompiled with CFR 0.152.
 */
package me.vaan.mapjammer;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.io.File;
import me.vaan.mapjammer.implementation.Setup;
import me.vaan.mapjammer.runnables.CheckPlayers;
import me.vaan.mapjammer.util.ConfigStorage;
import me.vaan.mapjammer.util.ShowHideInterface;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.dynmap.DynmapCommonAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.squaremap.api.PlayerManager;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;

public final class MapJammer
extends JavaPlugin
implements SlimefunAddon {
    public void onEnable() {
        this.configure();
        this.startMapTask();
        ItemGroup group = new ItemGroup(new NamespacedKey((Plugin)this, "map_jammer"), (ItemStack)new CustomItemStack(Material.COMPASS, "&eMap Jamming", new String[0]));
        new Setup(this, group);
    }

    private void startMapTask() {
        PluginManager pm = this.getServer().getPluginManager();
        long period = 20L * (long)ConfigStorage.TIME_FRAME;
        if (pm.isPluginEnabled("squaremap")) {
            Squaremap sqmp = SquaremapProvider.get();
            final PlayerManager mng = sqmp.playerManager();
            ShowHideInterface showHideInterface = new ShowHideInterface(){

                @Override
                public void show(Player p) {
                    mng.show(p.getUniqueId());
                }

                @Override
                public void hide(Player p) {
                    mng.hide(p.getUniqueId());
                }
            };
            new CheckPlayers(showHideInterface).runTaskTimer((Plugin)this, 0L, period);
            return;
        }
        Plugin dynmap = pm.getPlugin("dynmap");
        if (dynmap != null && dynmap.isEnabled()) {
            final DynmapCommonAPI dynmapAPI = (DynmapCommonAPI)dynmap;
            ShowHideInterface showHideInterface = new ShowHideInterface(){

                @Override
                public void show(Player p) {
                    dynmapAPI.setPlayerVisiblity(p.getName(), true);
                }

                @Override
                public void hide(Player p) {
                    dynmapAPI.setPlayerVisiblity(p.getName(), false);
                }
            };
            new CheckPlayers(showHideInterface).runTaskTimer((Plugin)this, 0L, period);
            return;
        }
        this.setEnabled(false);
        this.getLogger().warning("No supported map plugin found, MapJammers won't work.");
    }

    private void configure() {
        FileConfiguration config = this.getConfig();
        this.getDataFolder().mkdirs();
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        new ConfigStorage(config);
    }

    public void onDisable() {
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return null;
    }
}

